/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestServlet.java 64521 2012-01-06 20:14:52Z dougd $
 */

package com.sun.ts.tests.jsf.api.javax_faces.event.postkeepflashvalueevent;

import java.io.IOException;
import java.io.PrintWriter;

import javax.faces.application.Application;
import javax.faces.event.PostKeepFlashValueEvent;
import javax.faces.event.SystemEvent;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.sun.ts.tests.jsf.api.javax_faces.event.common.BaseSystemEventTestServlet;
import com.sun.ts.tests.jsf.common.util.JSFTestUtil;

public class TestServlet extends BaseSystemEventTestServlet {
    private static final String POST_KEY = "postkey"; 
    
    @Override
    protected SystemEvent createEvent(Object src) {
	return new PostKeepFlashValueEvent(POST_KEY);
    }
    
    // ------------------------------------------- PostKeepFlashValueEvent
    
    public void postKeepFlashValueEventGetKeyTest(HttpServletRequest request,
	    HttpServletResponse response) throws ServletException, IOException {
	PrintWriter pw = response.getWriter();
	Application app = getFacesContext().getApplication();

	if (app != null) {
	    PostKeepFlashValueEvent pKeep = (PostKeepFlashValueEvent) createEvent(app);
	    String result = pKeep.getKey();
	    
	    if (!POST_KEY.equals(result)) {
		pw.println(JSFTestUtil.FAIL + " Wrong key value!" + JSFTestUtil.NL +
			"Expected: " + POST_KEY + JSFTestUtil.NL +
			"Received: " + result);
	    } else {
		pw.println(JSFTestUtil.PASS);
	    }
	    
	} else {
	    pw.println(JSFTestUtil.FAIL +" Unexpected problem obtaining "
		    + "Application instance.");
	}
    }
    
} // TestServlet