/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestServlet.java 63987 2011-11-04 18:50:14Z dougd $
 */
package com.sun.ts.tests.jsf.api.javax_faces.factoryfinder.decorated;

import com.sun.ts.tests.jsf.common.factories.TCKDecoratedContextFactory;
import com.sun.ts.tests.jsf.common.servlets.FactoryTCKServlet;
import javax.faces.FactoryFinder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import java.io.IOException;
import java.io.PrintWriter;
import javax.faces.context.FacesContextFactory;

public class TestServlet extends FactoryTCKServlet {

    public void getFactoryDecoratedTest(
            HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();

        String expectFactNames =
                "com.sun.ts.tests.jsf.common.factories." +
                "TCKContextFactoryFour and com.sun.ts.tests.jsf.common." +
                "factories.TCKContextFactoryThree";

        try {
            FacesContextFactory fcf =
                    (FacesContextFactory) FactoryFinder.getFactory(
                    FactoryFinder.FACES_CONTEXT_FACTORY);

            TCKDecoratedContextFactory tckFactory = 
                    (TCKDecoratedContextFactory) fcf.getWrapped();
            String factNameFour = tckFactory.getClass().getCanonicalName();
            String factNameThree = tckFactory.getParent();

            if (factNameThree.contains("TCKContextFactoryThree") &&
                    factNameFour.contains("TCKContextFactoryFour")) {
                pw.println("Test PASSED");
            } else {
                pw.println("FacesContext Were not Decorated in correct order.");
                pw.println("Found: " + factNameThree + " And " + factNameFour);
                pw.println("Expected: " + expectFactNames);
                pw.println("Test FAILED.");
            }

        } catch (Exception e) {
            pw.println("Test FAILED.");
            pw.println(e.toString());
        }
    }
}