/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestServlet.java 64095 2011-11-23 14:59:12Z dougd $
 */

package com.sun.ts.tests.jsf.api.javax_faces.model.datamodelevent;

import com.sun.ts.tests.jsf.common.servlets.HttpTCKServlet;
import com.sun.ts.tests.jsf.common.util.JSFTestUtil;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.faces.model.DataModel;
import javax.faces.model.ArrayDataModel;
import javax.faces.model.DataModelEvent;

import java.io.IOException;
import java.io.PrintWriter;

public class TestServlet extends HttpTCKServlet {
	/**
     * <p>Initializes this {@link javax.servlet.Servlet}.</p>
     * 
     * @param config this Servlet's configuration
     * @throws javax.servlet.ServletException if an error occurs
     */
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }
    
// ---------------------------------------------------------------- Test Methods
    
    public void dataModelEventTest(HttpServletRequest request, 
                                   HttpServletResponse response)
    throws ServletException, IOException {
        PrintWriter out = response.getWriter();
        String[] data = { "string" };
        DataModel model = new ArrayDataModel(data);
        
        DataModelEvent event = new DataModelEvent(model, 0, "string1");
        
        if (event.getDataModel() != model) {
            out.println(JSFTestUtil.FAIL + " getDataModel() didn't return" +
                    "the expected 'model'." + JSFTestUtil.NL +
                    "Expected: " + model.toString() +
                    "Received: " + event.getDataModel().toString());

            return;
        }
        
        if (event.getRowIndex() != 0) {
            out.println(JSFTestUtil.FAIL + " Unexpected v alue returned from getRowIndex()!"+ JSFTestUtil.NL +
            		"Row index received: " + event.getRowIndex());

            return;
        }
        
        if (event.getRowData() != "string1") {
            out.println(JSFTestUtil.FAIL + " getRowData() returned an unexpected value." + JSFTestUtil.NL +
            		"Expected: " + "string1" + JSFTestUtil.NL +
            		"Received: " + event.getRowData());

            return;
        }
        
        event = new DataModelEvent(model, -1, null);
        
        if (event.getDataModel() != model) {
            out.println(JSFTestUtil.FAIL + " getDataModel() didn't return the expected value." + JSFTestUtil.NL +
            		"Expected: " + model.toString() + JSFTestUtil.NL +
            		"Received: " + event.getDataModel().toString());

            return;
        }

        if (event.getRowIndex() != -1) {
            out.println(JSFTestUtil.FAIL + " Expected getRowIndex() to return -1." + JSFTestUtil.NL +
            		"Row index received: " + event.getRowIndex());

            return;
        }

        if (event.getRowData() != null) {
            out.println(JSFTestUtil.FAIL + " getRowData() returned an unexpected value." + JSFTestUtil.NL +
            		"Expected: null" + JSFTestUtil.NL +
            		"Received: " + event.getRowData());

            return;
        }
        
        out.println(JSFTestUtil.PASS);
    }

}
