/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TCKViewRoot.java 65622 2012-03-30 12:27:35Z dougd $
 */

package com.sun.ts.tests.jsf.api.javax_faces.view.common;

import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.FacesContext;

public class TCKViewRoot extends UIViewRoot {
    private boolean vutreecalled = Boolean.FALSE;
    private boolean savevucalled = Boolean.FALSE;
    private boolean restorevucalled = Boolean.FALSE;

    // Does not matter what we return here!
    public boolean visitTree(VisitContext context, VisitCallback callback) {
	this.vutreecalled = Boolean.TRUE;

	return Boolean.TRUE;
    }

    // Does not matter what we return here!
    public Object saveView(FacesContext context) {
	this.savevucalled = Boolean.TRUE;

	return Boolean.TRUE;
    }

    // Does not matter what we return here!
    public UIViewRoot restoreView(FacesContext context, String viewId,
	    String renderKitId) {
	this.restorevucalled = Boolean.TRUE;

	return context.getViewRoot();
    }

    /**
     * Validate if the visitTree method has been called.
     * 
     * @return - true of visitTree method has been called
     */
    public boolean getVutree() {
	return this.vutreecalled;
    }

    /**
     * Reset the default value so it appears that visitTree method has not been
     * called.
     */
    public void resetVutree() {
	vutreecalled = Boolean.FALSE;
    }

    /**
     * Validate if the saveView method has been called.
     * 
     * @return - true id saveView method has been called
     */
    public boolean getSaveVu() {
	return this.savevucalled;
    }

    /**
     * Validate if the restoreView method has been called.
     * 
     * @return - true id restoreView method has been called
     */
    public boolean getRestoreVu() {
	return this.restorevucalled;
    }
}
