/*
 * Copyright (c) 2009, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: URLClient.java 72258 2013-06-28 12:44:18Z dougd $
 */
package com.sun.ts.tests.jsf.spec.appconfigresources.relative_ordering;

import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSpan;
import com.sun.javatest.Status;
import com.sun.ts.tests.jsf.common.client.BaseHtmlUnitClient;
import java.io.PrintWriter;
import java.util.Formatter;

public class URLClient extends BaseHtmlUnitClient {

	private static final String CONTEXT_ROOT = "/jsf_appconfigresources_relative_ordering_web";;
	private static final String SPAN = "span";

	public static void main(String[] args) {
		URLClient theTests = new URLClient();
		Status s = theTests.run(args, new PrintWriter(System.out, true),
				new PrintWriter(System.err, true));
		s.exit();
	}

	@Override
	public Status run(String[] args, PrintWriter out, PrintWriter err) {
		return super.run(args, out, err);
	}

	// ------------------------------------------------------------ Test Methods
	/*
	 * @class.setup_props: webServerHost; webServerPort; ts_home;
	 */
	/**
	 * @testName: testDocumentRelativeOrderingTest1
	 * @assertion_ids: PENDING
	 * @test_Strategy: Test to make sure that the ordering of artifacts is
	 *                 correct, when using the Relative-ordering That the
	 *                 expected pattern is found.
	 * 
	 * @since 2.0
	 */
	public void testDocumentRelativeOrderingTest1() throws Fault {
		StringBuilder messages = new StringBuilder(128);
		Formatter formatter = new Formatter(messages);

		HtmlPage page = getPage(CONTEXT_ROOT + "/faces/testOne.xhtml");

		// -------------------------------------------------------------- case 1
		String expected = "Order Correct: true";
		HtmlSpan result = (HtmlSpan) getElementOfTypeIncludingId(page, SPAN,
				"status");

		if (!validateExistence("result", SPAN, result, formatter)) {
			handleTestStatus(messages);
			return;
		}

		super.validateElementValue(result, expected, formatter);

		handleTestStatus(messages);
	}
}
