/*
 * Copyright (c) 2009, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: URLClient.java 72268 2013-06-28 20:13:09Z dougd $
 */
package com.sun.ts.tests.jsf.spec.jstl.fncontainsignore;

import java.io.PrintWriter;
import java.util.Formatter;

import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSpan;
import com.sun.javatest.Status;
import com.sun.ts.tests.jsf.common.client.BaseHtmlUnitClient;

public class URLClient extends BaseHtmlUnitClient {

	private static final String SERVLET_MAPPING = "/faces";
	private static final String CONTEXT_ROOT = "/jsf_jstl_fncontainsignore_web"
			+ SERVLET_MAPPING;
	private static final String TAG_NAME = "span";

	public static void main(String[] args) {
		URLClient theTests = new URLClient();
		Status s = theTests.run(args, new PrintWriter(System.out, true),
				new PrintWriter(System.err, true));
		s.exit();
	}

	public Status run(String[] args, PrintWriter out, PrintWriter err) {
		return super.run(args, out, err);
	}

	/*
	 * @class.setup_props: webServerHost; webServerPort; ts_home;
	 */
	/**
	 * @testName: jstlFunctionContainsIgnoreCaseTagTest
	 * @assertion_ids: PENDING
	 * @test_Strategy: Validate "fn:contains" JSTL function tag.
	 * 
	 *                 Test to make sure the following:
	 * 
	 *                 case1: 'gaMMa RAy', 'gamma ray' = true case2: 'AlphA
	 *                 biTS', 'gamma' = false case3: 'alPha Beta', 'a beta' =
	 *                 true case4: 'alpha beta', 'ALPHA b' = true case5: null,
	 *                 'a Beta' = false case6: 'Alpha betA', null = true
	 * 
	 * @since 2.0
	 */
	public void jstlFunctionContainsIgnoreCaseTagTest() throws Fault {
		StringBuilder messages = new StringBuilder(128);
		Formatter formatter = new Formatter(messages);

		HtmlPage page = getPage(CONTEXT_ROOT + "/fncontainsignore.xhtml");

		// -------------------------------------------------------------- case 1
		HtmlSpan testOne = (HtmlSpan) getElementOfTypeIncludingId(page,
				TAG_NAME, "case1");

		if (!validateExistence("case1", TAG_NAME, testOne, formatter)) {
			handleTestStatus(messages);
			return;
		}

		validateElementValue(testOne, "true", formatter);

		// -------------------------------------------------------------- case 2
		HtmlSpan testTwo = (HtmlSpan) getElementOfTypeIncludingId(page,
				TAG_NAME, "case2");

		if (!validateExistence("case2", TAG_NAME, testTwo, formatter)) {
			handleTestStatus(messages);
			return;
		}

		validateElementValue(testTwo, "false", formatter);

		// -------------------------------------------------------------- case 3
		HtmlSpan testThree = (HtmlSpan) getElementOfTypeIncludingId(page,
				TAG_NAME, "case3");

		if (!validateExistence("case3", TAG_NAME, testThree, formatter)) {
			handleTestStatus(messages);
			return;
		}

		validateElementValue(testThree, "true", formatter);

		// -------------------------------------------------------------- case 4
		HtmlSpan testFour = (HtmlSpan) getElementOfTypeIncludingId(page,
				TAG_NAME, "case4");

		if (!validateExistence("case4", TAG_NAME, testFour, formatter)) {
			handleTestStatus(messages);
			return;
		}

		validateElementValue(testFour, "true", formatter);

		// -------------------------------------------------------------- case 5
		HtmlSpan testFive = (HtmlSpan) getElementOfTypeIncludingId(page,
				TAG_NAME, "case5");

		if (!validateExistence("case5", TAG_NAME, testFive, formatter)) {
			handleTestStatus(messages);
			return;
		}

		validateElementValue(testFive, "false", formatter);

		// -------------------------------------------------------------- case 6
		HtmlSpan testSix = (HtmlSpan) getElementOfTypeIncludingId(page,
				TAG_NAME, "case6");

		if (!validateExistence("case6", TAG_NAME, testSix, formatter)) {
			handleTestStatus(messages);
			return;
		}

		validateElementValue(testSix, "true", formatter);

		handleTestStatus(messages);

	} // END jstlFunctionContainsIgnoreCaseTagTest //
}
