/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.Command;
import com.sun.javatest.Harness;
import com.sun.javatest.ProductInfo;
import com.sun.javatest.ResourceTable;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestResult;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import com.sun.javatest.util.Timer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.util.Date;
import java.util.Vector;

public abstract class Script {
    private static ResourceTable sourceTable = new ResourceTable();
    protected TestDescription td;
    protected String[] excludedTestCases;
    protected TestEnvironment env;
    protected String[] scriptArgs;
    protected WorkDirectory workDir;
    protected String cmdOut1Name = "out1";
    protected String cmdOut2Name = "out2";
    protected BackupPolicy backupPolicy = BackupPolicy.noBackups();
    protected ClassLoader loader;
    protected PrintWriter trOut;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Script.class);
    private TimeoutProvider provider = null;
    protected static final Status error_badExecuteArgs = Status.error(i18n.getString("script.badExecuteArgs"));
    protected static final Status error_badTestClassDir = Status.error(i18n.getString("script.badTestClassDir"));
    protected static final Status error_compFailUnexp = Status.error(i18n.getString("script.compFailUnexp"));
    protected static final Status error_noActionSpecified = Status.error(i18n.getString("script.noAction"));
    protected static final Status error_noExecuteClass = Status.error(i18n.getString("script.noExecuteClass"));
    protected static final Status error_noExtnInSource = Status.error(i18n.getString("script.noExtnInSrc"));
    protected static final Status error_noRMIClasses = Status.error(i18n.getString("script.noRMIClasses"));
    protected static final Status error_noSource = Status.error(i18n.getString("script.noSource"));
    protected static final Status fail_compFailUnexp = Status.failed(i18n.getString("script.compFailUnexp"));
    protected static final Status fail_compSuccUnexp = Status.failed(i18n.getString("script.compSuccUnexp"));
    protected static final Status fail_execSuccUnexp = Status.failed(i18n.getString("script.execSuccUnexp"));
    protected static final Status pass_compFailExp = Status.passed(i18n.getString("script.compFailExp"));
    protected static final Status pass_compSuccExp = Status.passed(i18n.getString("script.compSuccExp"));
    protected static final Status pass_execFailExp = Status.passed(i18n.getString("script.execFailExp"));
    protected static final Status noSource = error_noSource;
    protected static final Status noExtnInSource = error_noExtnInSource;
    private static final String[] nullArgs = new String[0];
    private static final String DEFAULT_COMPILE_COMMAND = "compile";
    private static final String DEFAULT_EXECUTE_COMMAND = "execute";
    private static final String DEFAULT_RMIC_COMMAND = "rmic";
    private static final String defaultClassDir = "classes";
    private static String osInfo;
    protected static final Timer alarmTimer;
    private TestResult testResult;
    private Alarm alarm;
    private boolean jtrIfPassed = System.getProperty("javatest.script.jtrIfPassed", "true").equals("true");
    protected Harness.Observer notifier;
    private static boolean debugAlarm;

    public void initArgs(String[] args) {
        this.scriptArgs = args;
    }

    public void initTestDescription(TestDescription td) {
        this.td = td;
        this.testResult = new TestResult(td);
        this.trOut = this.testResult.getTestCommentWriter();
    }

    public void initExcludedTestCases(String[] excludedTestCases) {
        this.excludedTestCases = excludedTestCases;
    }

    public void initTestEnvironment(TestEnvironment env) {
        this.env = env;
    }

    public void initWorkDir(WorkDirectory workDir) {
        this.workDir = workDir;
    }

    public void initBackupPolicy(BackupPolicy backupPolicy) {
        this.backupPolicy = backupPolicy;
    }

    public void initClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    protected void initDelegate(Script s, String[] scriptArgs) {
        s.scriptArgs = scriptArgs;
        s.td = this.td;
        s.env = this.env;
        s.workDir = this.workDir;
        s.backupPolicy = this.backupPolicy;
        s.loader = this.loader;
        s.testResult = this.testResult;
        s.trOut = this.trOut;
        s.jtrIfPassed = this.jtrIfPassed;
    }

    protected void initTestResult(TestResult tr) {
        if (this.testResult != null) {
            throw new IllegalStateException();
        }
        this.testResult = tr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.workDir == null) {
            throw new NullPointerException(i18n.getString("script.noWorkDir"));
        }
        if (this.td == null) {
            throw new NullPointerException(i18n.getString("script.noTestDesc"));
        }
        if (this.testResult == null) {
            throw new NullPointerException(i18n.getString("script.noTestRslt"));
        }
        if (this.env == null) {
            throw new NullPointerException(i18n.getString("script.noTestEnv"));
        }
        Status execStatus = null;
        File testWork = this.workDir.getFile(this.td.getRootRelativeDir().getPath());
        Class<Script> clazz = Script.class;
        synchronized (Script.class) {
            String classDir;
            if (!testWork.exists()) {
                testWork.mkdirs();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            String descUrl = this.td.getFile().toURI().toASCIIString();
            String id = this.td.getId();
            if (id != null) {
                descUrl = descUrl + "#" + id;
            }
            this.testResult.putProperty("description", descUrl);
            this.testResult.putProperty("start", TestResult.formatDate(new Date()));
            this.testResult.putProperty("javatestVersion", ProductInfo.getVersion());
            this.testResult.putProperty("work", testWork.getAbsolutePath());
            this.testResult.putProperty("environment", this.env.getName());
            if (osInfo == null) {
                String osArch = System.getProperty("os.arch");
                String osName = System.getProperty("os.name");
                String osVersion = System.getProperty("os.version");
                osInfo = osName + " " + osVersion + " (" + osArch + ")";
            }
            this.testResult.putProperty("javatestOS", osInfo);
            if (this.excludedTestCases != null) {
                this.testResult.putProperty("excludedTestCases", StringArray.join(this.excludedTestCases));
            }
            File f = (classDir = this.td.getParameter("classDir")) == null ? this.workDir.getFile(defaultClassDir) : new File(testWork, classDir);
            this.env.putUrlAndFile("testClassDir", f);
            this.env.putUrlAndFile("testWorkDir", testWork);
            this.env.put("test", this.td.getFile().getPath());
            this.env.put("testDir", this.td.getFile().getParent());
            this.env.put("testURL", descUrl);
            this.env.put("testPath", this.td.getRootRelativeURL());
            int timeout = this.getTestTimeout();
            PrintStream out = System.out;
            PrintStream err = System.err;
            try {
                this.testResult.putProperty("test", this.td.getRootRelativeURL());
                this.testResult.putProperty("script", this.getClass().getName() + " " + StringArray.join(this.scriptArgs));
                if (timeout > 0) {
                    this.testResult.putProperty("timeoutSeconds", Integer.toString(timeout));
                    this.setAlarm(timeout * 1000);
                }
                execStatus = this.run(this.scriptArgs, this.td, this.env);
            }
            finally {
                if (timeout > 0) {
                    this.setAlarm(0);
                }
                try {
                    System.setOut(System.out);
                    System.setErr(System.err);
                }
                catch (SecurityException ignore) {}
                if (Thread.interrupted()) {
                    execStatus = Status.error(i18n.getString("script.interrupted"));
                }
                this.testResult.putProperty("end", TestResult.formatDate(new Date()));
                if (execStatus == null) {
                    execStatus = Status.error(i18n.getString("script.noStatus"));
                } else {
                    switch (execStatus.getType()) {
                        case 0: 
                        case 1: 
                        case 2: {
                            break;
                        }
                        default: {
                            execStatus = Status.error(i18n.getString("script.badTestStatus", execStatus));
                        }
                    }
                }
            }
            this.testResult.setEnvironment(this.env);
            this.testResult.setStatus(execStatus);
            try {
                if (execStatus.getType() != 0 || this.jtrIfPassed) {
                    this.testResult.writeResults(this.workDir, this.backupPolicy);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            return;
        }
    }

    public abstract Status run(String[] var1, TestDescription var2, TestEnvironment var3);

    public TestDescription getTestDescription() {
        return this.td;
    }

    public TestResult getTestResult() {
        return this.testResult;
    }

    public boolean getJTRIfPassed() {
        return this.jtrIfPassed;
    }

    public void setJTRIfPassed(boolean b) {
        this.jtrIfPassed = b;
    }

    protected void setAlarm(int timeout) {
        this.setAlarm(timeout, Thread.currentThread());
    }

    protected void setAlarm(int timeout, Thread threadToInterrupt) {
        if (this.alarm != null) {
            this.alarm.cancel();
            this.alarm = null;
        }
        if (timeout > 0) {
            this.alarm = new Alarm(timeout, threadToInterrupt);
        }
    }

    public void setTimeoutProvider(TimeoutProvider provider) {
        if (provider != this.provider) {
            this.provider = provider;
        }
    }

    public TimeoutProvider getTimeoutProvider() {
        if (this.provider == null) {
            this.provider = new DefaultTimeoutProvider();
        }
        return this.provider;
    }

    protected int getTestTimeout() {
        return this.getTimeoutProvider().getTestTimeout();
    }

    protected Status compileIndividually(String[] srcs) {
        return this.compileIndividually(DEFAULT_COMPILE_COMMAND, srcs);
    }

    protected Status compileIndividually(String command, String[] srcs) {
        if (srcs.length == 0) {
            return error_noSource;
        }
        for (int i = 0; i < srcs.length; ++i) {
            Status s = this.compileOne(command, srcs[i]);
            if (s.isPassed()) continue;
            return s;
        }
        return pass_compSuccExp;
    }

    protected Status compileIndividually(File[] srcs) {
        return this.compileIndividually(DEFAULT_COMPILE_COMMAND, Script.filesToStrings(srcs));
    }

    protected Status compileIndividually(String command, File[] srcs) {
        return this.compileIndividually(command, Script.filesToStrings(srcs));
    }

    protected Status compileOne(String src) {
        return this.compileOne(DEFAULT_COMPILE_COMMAND, src);
    }

    protected Status compileOne(String command, String src) {
        return this.compileTogether(command, new String[]{src});
    }

    protected Status compileOne(File src) {
        return this.compileOne(DEFAULT_COMPILE_COMMAND, src.getPath());
    }

    protected Status compileOne(String command, File src) {
        return this.compileOne(command, src.getPath());
    }

    protected Status compileTogether(String[] srcs) {
        return this.compileTogether(DEFAULT_COMPILE_COMMAND, srcs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Status compileTogether(String command, String[] srcs) {
        if (srcs.length == 0) {
            return error_noSource;
        }
        try {
            String[] classDir = this.env.lookup("testClassDir");
            if (classDir == null || classDir.length != 1) {
                return error_badTestClassDir;
            }
            File f = new File(classDir[0]);
            if (!f.exists()) {
                f.mkdirs();
            }
        }
        catch (TestEnvironment.Fault e) {
            return error_badTestClassDir;
        }
        String primarySrcFile = srcs[0];
        int dot = primarySrcFile.lastIndexOf(46);
        if (dot == -1) {
            return error_noExtnInSource;
        }
        String extn = primarySrcFile.substring(dot);
        this.env.put("testSource", srcs);
        try {
            boolean ok = sourceTable.acquire(srcs, 600000);
            if (!ok) {
                Status status = Status.error(i18n.getString("script.srcLockTimeout"));
                return status;
            }
            Status status = this.invokeCommand(command + extn);
            return status;
        }
        catch (InterruptedException e) {
            Status status = Status.error(i18n.getString("script.srcLockInterrupted"));
            return status;
        }
        finally {
            sourceTable.release(srcs);
        }
    }

    protected Status compileTogether(File[] srcs) {
        return this.compileTogether(DEFAULT_COMPILE_COMMAND, Script.filesToStrings(srcs));
    }

    protected Status compileTogether(String command, File[] srcs) {
        return this.compileTogether(command, Script.filesToStrings(srcs));
    }

    protected Status compileIfNecessary(String[] srcs, String classDir) {
        return this.compileIfNecessary(DEFAULT_COMPILE_COMMAND, srcs, classDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Status compileIfNecessary(String command, String[] srcs, String classDir) {
        File cdf;
        if (srcs.length == 0) {
            return error_noSource;
        }
        if (classDir == null) {
            classDir = "$testClassDir";
        }
        if (classDir.startsWith("$")) {
            try {
                String[] cd = this.env.resolve(classDir);
                if (cd == null || cd.length != 1) {
                    return error_badTestClassDir;
                }
                classDir = cd[0];
            }
            catch (TestEnvironment.Fault e) {
                return error_badTestClassDir;
            }
        }
        if (!(cdf = new File(classDir)).exists()) {
            cdf.mkdirs();
        }
        Vector<String> v = new Vector<String>(0, srcs.length);
        for (int i = 0; i < srcs.length; ++i) {
            String pkgPrefix;
            String className;
            String src;
            block28: {
                int x;
                int y = (src = srcs[i]).indexOf(46, (x = src.lastIndexOf(File.separatorChar)) + 1);
                className = src.substring(x + 1, y == -1 ? src.length() : y);
                BufferedReader r = null;
                try {
                    r = new BufferedReader(new FileReader(src));
                    StreamTokenizer tr = new StreamTokenizer(r);
                    tr.ordinaryChar(47);
                    tr.slashStarComments(true);
                    tr.slashSlashComments(true);
                    tr.wordChars(46, 46);
                    int c = tr.nextToken();
                    if (c == -3 && tr.sval.equals("package")) {
                        c = tr.nextToken();
                        if (c == -3) {
                            pkgPrefix = tr.sval.replace('.', File.separatorChar) + File.separatorChar;
                            break block28;
                        } else {
                            this.trOut.println(i18n.getString("script.badPackage"));
                            v.addElement(src);
                            continue;
                        }
                    }
                    pkgPrefix = "";
                }
                catch (IOException e) {
                    this.trOut.println(i18n.getString("script.badDateStamp", new Object[]{src, e}));
                    v.addElement(src);
                    continue;
                }
                finally {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
            }
            File srcFile = new File(src);
            File classFile = new File(classDir, pkgPrefix + className + ".class");
            if (classFile.exists() && classFile.lastModified() > srcFile.lastModified()) {
                this.trOut.println(i18n.getString("script.upToDate", src));
                continue;
            }
            v.addElement(src);
        }
        if (v.size() > 0) {
            Object[] necessarySrcs = new String[v.size()];
            v.copyInto(necessarySrcs);
            return this.compileTogether(command, (String[])necessarySrcs);
        }
        return Status.passed(i18n.getString("script.allUpToDate"));
    }

    protected Status compileIfNecessary(File[] srcs, String classDir) {
        return this.compileIfNecessary(DEFAULT_COMPILE_COMMAND, Script.filesToStrings(srcs), classDir);
    }

    protected Status compileIfNecessary(String command, File[] srcs, String classDir) {
        return this.compileIfNecessary(command, Script.filesToStrings(srcs), classDir);
    }

    protected Status execute(String executeClass, String executeArgs) {
        return this.execute(DEFAULT_EXECUTE_COMMAND, executeClass, executeArgs);
    }

    protected Status execute(String command, String executeClass, String executeArgs) {
        try {
            String[] args;
            String[] stringArray = args = executeArgs == null ? nullArgs : this.env.resolve(executeArgs);
            if (this.excludedTestCases != null) {
                args = this.exclude(args, this.excludedTestCases);
            }
            return this.execute(command, executeClass, args);
        }
        catch (TestEnvironment.Fault e) {
            this.trOut.println(i18n.getString("script.testEnvFault", new Object[]{executeArgs, e.toString()}));
            return error_badExecuteArgs;
        }
    }

    protected Status execute(String executeClass, String[] executeArgs) {
        return this.execute(DEFAULT_EXECUTE_COMMAND, executeClass, executeArgs);
    }

    protected Status execute(String command, String executeClass, String[] executeArgs) {
        if (executeClass == null || executeClass.length() == 0) {
            return error_noExecuteClass;
        }
        this.env.put("testExecuteClass", executeClass);
        this.env.put("testExecuteArgs", executeArgs);
        return this.invokeCommand(command);
    }

    protected Status rmiCompile(String[] classes) {
        return this.rmiCompile(DEFAULT_RMIC_COMMAND, classes);
    }

    protected Status rmiCompile(String command, String[] classes) {
        try {
            String[] classDir = this.env.lookup("testClassDir");
            if (classDir == null || classDir.length != 1) {
                return error_badTestClassDir;
            }
            File f = new File(classDir[0]);
            if (!f.exists()) {
                f.mkdirs();
            }
        }
        catch (TestEnvironment.Fault e) {
            return error_badTestClassDir;
        }
        if (classes == null || classes.length == 0) {
            return error_noRMIClasses;
        }
        this.env.put("testRmicClasses", classes);
        this.env.put("testRmicClass", classes);
        return this.invokeCommand(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Status invokeCommand(String key) {
        Status s = null;
        try {
            String[] command = this.env.lookup("command." + key);
            if (command.length == 0) {
                return Status.error(i18n.getString("script.noCommand", new Object[]{this.env.getName(), key}));
            }
            String className = command[0];
            String[] args = new String[command.length - 1];
            System.arraycopy(command, 1, args, 0, args.length);
            TestResult.Section section = this.testResult.createSection(key);
            section.getMessageWriter().println(i18n.getString("script.command", new Object[]{className, StringArray.join(args)}));
            PrintWriter out1 = null;
            PrintWriter out2 = null;
            try {
                out1 = section.createOutput(this.cmdOut1Name);
                out2 = section.createOutput(this.cmdOut2Name);
                s = this.invokeClass(className, args, out1, out2);
                out1.close();
                out2.close();
            }
            finally {
                if (out2 != null) {
                    out2.close();
                }
                if (out1 != null) {
                    out1.close();
                }
            }
            section.setStatus(s);
            return s;
        }
        catch (TestEnvironment.Fault e) {
            return Status.error(i18n.getString("script.badCommand", new Object[]{this.env.getName(), key}));
        }
    }

    protected void setDefaultCommandStreamNames(String out1Name, String out2Name) {
        this.cmdOut1Name = out1Name;
        this.cmdOut2Name = out2Name;
    }

    private Status invokeClass(String className, String[] args, PrintWriter out1, PrintWriter out2) {
        Command testCommand;
        try {
            Class<?> c = this.loader == null ? Class.forName(className) : this.loader.loadClass(className);
            testCommand = (Command)c.newInstance();
        }
        catch (ClassCastException e) {
            return Status.error(i18n.getString("script.cantRunClass", new Object[]{className, Command.class.getName()}));
        }
        catch (ClassNotFoundException ex) {
            return Status.error(i18n.getString("script.cantFindClass", new Object[]{className, this.env.getName()}));
        }
        catch (IllegalAccessException ex) {
            return Status.error(i18n.getString("script.cantAccessClass", new Object[]{className, this.env.getName()}));
        }
        catch (IllegalArgumentException ex) {
            return Status.error(i18n.getString("script.badClassName", new Object[]{className, this.env.getName()}));
        }
        catch (InstantiationException ex) {
            return Status.error(i18n.getString("script.cantCreateClass", new Object[]{className, this.env.getName()}));
        }
        catch (ThreadDeath e) {
            throw (ThreadDeath)e.fillInStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace(out1);
            return Status.error(i18n.getString("script.unexpLoadExc", new Object[]{className, e}));
        }
        catch (Error e) {
            e.printStackTrace(out1);
            return Status.error(i18n.getString("script.unexpLoadErr", new Object[]{className, e}));
        }
        catch (Throwable e) {
            e.printStackTrace(out1);
            return Status.error(i18n.getString("script.unexpLoadThr", new Object[]{className, e}));
        }
        try {
            testCommand.setClassLoader(this.loader);
            return testCommand.run(args, out1, out2);
        }
        catch (ThreadDeath e) {
            throw (ThreadDeath)e.fillInStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace(out1);
            return Status.failed(i18n.getString("script.unexpExecExc", new Object[]{className, e}));
        }
        catch (Error e) {
            e.printStackTrace(out1);
            return Status.failed(i18n.getString("script.unexpExecErr", new Object[]{className, e}));
        }
        catch (Throwable e) {
            e.printStackTrace(out1);
            return Status.error(i18n.getString("script.unexpExecThr", new Object[]{className, e}));
        }
    }

    protected String[] exclude(String[] args, String[] testCases) {
        if (testCases == null) {
            return args;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < testCases.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(testCases[i]);
        }
        String[] newArgs = new String[args.length + 2];
        newArgs[0] = "-exclude";
        newArgs[1] = sb.toString();
        System.arraycopy(args, 0, newArgs, 2, args.length);
        this.testResult.putProperty("exclude", newArgs[1]);
        return newArgs;
    }

    protected static String[] filesToStrings(File[] files) {
        String[] strings = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            strings[i] = files[i].getPath();
        }
        return strings;
    }

    public boolean useNotifier() {
        return false;
    }

    public void setNotifier(Harness.Observer notifier) {
        this.notifier = notifier;
    }

    static {
        alarmTimer = new Timer();
        debugAlarm = Boolean.getBoolean("debug.com.sun.javatest.Script.Alarm");
    }

    private class Alarm
    implements Timer.Timeable {
        private int delay;
        private Thread threadToInterrupt;
        private int count;
        private Timer.Entry entry;

        Alarm(int delay) {
            this(delay, Thread.currentThread());
        }

        Alarm(int delay, Thread threadToInterrupt) {
            if (threadToInterrupt == null) {
                throw new NullPointerException();
            }
            this.delay = delay;
            this.threadToInterrupt = threadToInterrupt;
            this.entry = alarmTimer.requestDelayedCallback(this, delay);
            if (debugAlarm) {
                System.err.println(i18n.getString("script.alarm.started", this));
            }
        }

        synchronized void cancel() {
            if (debugAlarm) {
                System.err.println(i18n.getString("script.alarm.cancelled", this));
            }
            alarmTimer.cancel(this.entry);
        }

        @Override
        public synchronized void timeout() {
            if (this.count == 0) {
                Script.this.trOut.println(i18n.getString("script.timeout", new Float((float)this.delay / 1000.0f)));
            } else if (this.count % 100 == 0) {
                Script.this.trOut.println(i18n.getString("script.notResponding", new Integer(this.count)));
                if (this.count % 1000 == 0) {
                    System.err.println(i18n.getString("script.timedOut", new Object[]{Script.this.td.getRootRelativeURL(), new Integer(this.count)}));
                }
            }
            if (debugAlarm) {
                System.err.println(i18n.getString("script.alarm.interrupt", new Object[]{this, this.threadToInterrupt}));
            }
            this.threadToInterrupt.interrupt();
            ++this.count;
            this.entry = alarmTimer.requestDelayedCallback(this, 100L);
        }
    }

    private class DefaultTimeoutProvider
    implements TimeoutProvider {
        private DefaultTimeoutProvider() {
        }

        @Override
        public int getTestTimeout() {
            float factor = 1.0f;
            try {
                String[] jtf = Script.this.env.lookup("javatestTimeoutFactor");
                if (jtf != null) {
                    if (jtf.length == 1) {
                        factor = Float.parseFloat(jtf[0]);
                    } else if (jtf.length == 2) {
                        factor = Float.parseFloat(jtf[1]);
                    }
                }
            }
            catch (TestEnvironment.Fault fault) {
                // empty catch block
            }
            return (int)(600.0f * factor);
        }
    }

    public static interface TimeoutProvider {
        public int getTestTimeout();
    }
}

