/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */

package com.sun.ts.tests.jsonb.api.model;

import javax.json.bind.adapter.JsonbAdapter;

public class SimpleStringAdapter implements JsonbAdapter<SimpleContainer, SimpleContainerAdapted> {
    @Override
    public SimpleContainerAdapted adaptToJson(SimpleContainer simpleContainer) throws Exception {
        SimpleContainerAdapted simpleContainerAdapted = new SimpleContainerAdapted();
        simpleContainerAdapted.setInstance(simpleContainer.getInstance() + " Adapted");
        return simpleContainerAdapted;
    }

    @Override
    public SimpleContainer adaptFromJson(SimpleContainerAdapted adapted) throws Exception {
        SimpleContainer simpleContainer = new SimpleContainer();
        simpleContainer.setInstance(adapted.getInstance().substring(0, adapted.getInstance().indexOf(" Adapted")));
        return simpleContainer;
    }
}
