/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */

package com.sun.ts.tests.jsonb.customizedmapping.instantiation.model;

import javax.json.bind.annotation.JsonbCreator;
import javax.json.bind.annotation.JsonbProperty;

public class SimpleCreatorContainer {
    private String stringInstance;
    private Integer integerInstance;
    private float floatInstance;

    @JsonbCreator
    public SimpleCreatorContainer(@JsonbProperty("stringInstance")  String stringInstance,
                                  @JsonbProperty("integerInstance") Integer integerInstance,
                                  @JsonbProperty("floatInstance") float floatInstance) {
        this.stringInstance = "Constructor String";
        this.integerInstance = 2;
        this.floatInstance = 2;
    }

    public String getStringInstance() {
        return stringInstance;
    }

    public Integer getIntegerInstance() {
        return integerInstance;
    }

    public float getFloatInstance() {
        return floatInstance;
    }
}
