/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */

package com.sun.ts.tests.jsonb.customizedmapping.serializers.model;

public class Cat extends Animal {
    public Cat() {}

    public Cat(int age, String name, float weight, boolean furry, boolean cuddly) {
        super(age, name, weight, furry);
        this.cuddly = cuddly;
    }

    private boolean cuddly;

    public boolean isCuddly() {
        return cuddly;
    }

    public void setCuddly(boolean cuddly) {
        this.cuddly = cuddly;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof Cat)) return false;
        if (!super.equals(o)) return false;

        Cat cat = (Cat) o;

        return cuddly == cat.cuddly;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (cuddly ? 1 : 0);
        return result;
    }
}
