/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: GetBodyContentTestTag.java 62554 2011-04-15 18:08:28Z dougd $
 */
 
package com.sun.ts.tests.jsp.api.javax_servlet.jsp.tagext.bodytagsupport;

import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.JspException;
import java.io.IOException;

public class GetBodyContentTestTag extends BodyTagSupport {

    /**
     * Default constructor.
     */
    public GetBodyContentTestTag() {
        super();
    }

    /**
     * Validate the that get/setBodyContent() work as expected.
     * @return Tag.EVAL_PAGE
     * @throws JspException if an unexpected error occurs
     */
    public int doEndTag() throws JspException {
        BodyContent bc = this.getBodyContent();
        try {
            if (bc != null) {
                if ("body content".equals(bc.getString().trim())) {
                    pageContext.getOut().println("Test PASSED");
                } else {
                    pageContext.getOut().println("Test FAILED.  Unexpected body" +
                        " content returned.  Expected: 'body content', received: " +
                        bc.getString());
                }
            } else {
                pageContext.getOut().println("Test FAILED.  BodyTagSupport.getBodyContent()" +
                    "returned null.");
            }
        } catch (IOException ioe) {
            throw new JspException("Unexpected IOException!", ioe);
        }
        return EVAL_PAGE;
    }
}
