/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: SimpleEmptyBody.java 62554 2011-04-15 18:08:28Z dougd $
 */
 
package com.sun.ts.tests.jsp.api.javax_servlet.jsp.tagext.simpletagsupport;

import com.sun.ts.tests.jsp.common.util.JspTestUtil;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import javax.servlet.jsp.tagext.JspFragment;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import java.io.IOException;

public class SimpleEmptyBody extends SimpleTagSupport {
    private boolean called;
    
    public SimpleEmptyBody() {
        super();
    }

    public void setJspBody(JspFragment jspBody) {
        this.called = true;
        super.setJspBody(jspBody);
    }

    public void doTag() throws JspException, IOException {
        JspTestUtil.debug("[SimpleEmptyBody] in doTag()");
        this.getJspBody();
        JspWriter out = this.getJspContext().getOut();
        
        if(called) {
            out.println("Test FAILED. setJspBody() unexpectedly called for empty body");
        } else {
            out.println("Test PASSED. setJspBody() not called");
        }
        this.called = false;
    }
}
