/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: SimpleGetSetJspContext.java 62554 2011-04-15 18:08:28Z dougd $
 */

/*
 * @(#)SimpleGetSetJspContext.java 1.1 10/31/02
 */
 
package com.sun.ts.tests.jsp.api.javax_servlet.jsp.tagext.simpletagsupport;

import com.sun.ts.tests.jsp.common.util.JspTestUtil;

import javax.servlet.jsp.tagext.SimpleTagSupport;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspContext;
import java.io.IOException;

public class SimpleGetSetJspContext extends SimpleTagSupport {

    /**
     * Default constructor.
     */
    public SimpleGetSetJspContext() {
        super();
    }

    /**
     * Validates that getJspContext() returns a non null value.  This indirectly
     * ensures that the container properly called setJspContext().
     *
     * @throws JspException - if an unexpected error occured.
     * @throws IOException - if an unexpected I/O error occured.
     */
    public void doTag()
        throws JspException, IOException {
        JspTestUtil.debug("[SimpleGetSetJspcontext] in doTag()");
        JspContext ctx = this.getJspContext();

        if (ctx != null) {
            ctx.getOut().println("Test PASSED");
        } else {
            throw new JspException("Test FAILED.  PageContext.getJspContext()" +
                "returned null.");
        }
    }
}
