/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: SimpleJspFragmentGetJspContext.java 62554 2011-04-15 18:08:28Z dougd $
 */
 
package com.sun.ts.tests.jsp.api.javax_servlet.jsp.tagext.simpletagsupport;

import com.sun.ts.tests.jsp.common.util.JspTestUtil;

import javax.servlet.jsp.tagext.SimpleTagSupport;
import javax.servlet.jsp.tagext.JspTag;
import javax.servlet.jsp.tagext.SimpleTag;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.JspFragment;
import java.io.IOException;

public class SimpleJspFragmentGetJspContext extends SimpleTagSupport {
    public SimpleJspFragmentGetJspContext() {
        super();
    }

    public void doTag() throws JspException, IOException {
        JspTestUtil.debug("[SimpleJspFragmentGetJspContext] in doTag()");
        JspFragment aBody = getJspBody();
        JspContext ctx = aBody.getJspContext();
        if(ctx == null) {
            this.getJspContext().getOut().println("Test FAILED in simple tag. jspFragment.getJspContext() returned null.");
        } else {
            ctx.getOut().println("Test PASSED in simple tag.");
        }
    }
}
