/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TASimpleTag.java 62554 2011-04-15 18:08:28Z dougd $
 */

/*
 * @(#)TASimpleTag.java 1.2 11/07/02
 */

package com.sun.ts.tests.jsp.api.javax_servlet.jsp.tagext.tagadapter;

import javax.servlet.jsp.tagext.SimpleTagSupport;
import javax.servlet.jsp.JspException;
import java.io.IOException;

/**
 * SimpleTag instance to validate the that this SimpleTag
 * is passed to the nested Classic tag wrapped with by
 * a TagAdapter.
 */
public class TASimpleTag extends SimpleTagSupport {

    /**
     * Default Constructor.
     */
    public TASimpleTag() {
        super();
    }

    /**
     * Invokes the JspFragment, in this case, a nested Classic Tag.
     * @throws JspException - if an unexpected error occurs
     * @throws IOException - if an I/O error occurs
     */
    public void doTag()
        throws JspException, IOException {
        this.getJspBody().invoke(this.getJspContext().getOut());
    }
}
