/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jsp.common.tags.tck;

import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.SimpleTagSupport;

/**
 * This tag is a simplified version of the jstl 
 * c:set tag. It assigns a String value to a variable.
 */
public class SetTag extends SimpleTagSupport {

    private String var, value;

    public void setVar(String var) {
        this.var = var;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void doTag() throws JspException {
        getJspContext().setAttribute(var, value, PageContext.PAGE_SCOPE);
    }
}
