/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */
package com.sun.ts.tests.servlet.api.common.sharedfiles;

import com.sun.ts.tests.servlet.common.util.StaticLog;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;

public final class SCAttributeListener
        implements ServletContextAttributeListener {

    public void attributeAdded(ServletContextAttributeEvent event) {
        StaticLog.add("SCAttributeListenerAdded:" + event.getName() + "," +
                event.getValue());
    }

    public void attributeRemoved(ServletContextAttributeEvent event) {
        StaticLog.add("SCAttributeListenerRemoved:" + event.getName() + "," +
                event.getValue());
    }

    public void attributeReplaced(ServletContextAttributeEvent event) {
        StaticLog.add("SCAttributeListenerReplaced:" + event.getName() + "," +
                event.getValue());
    }
}
