/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id:$
 */
package com.sun.ts.tests.servlet.api.javax_servlet.dispatchtest;

import java.io.IOException;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.RequestDispatcher;

public final class TestListener2 implements AsyncListener {

    public TestListener2() throws IOException {
    }

    public void onError(AsyncEvent event) throws IOException {
        event.getSuppliedResponse().getWriter().println("in onError method of TestListener2");
        event.getSuppliedResponse().getWriter().println(event.getThrowable().getMessage());
        event.getSuppliedResponse().getWriter().println(event.getSuppliedRequest().getAttribute(RequestDispatcher.ERROR_EXCEPTION));
        event.getAsyncContext().complete();
    }

    public void onStartAsync(AsyncEvent event) throws IOException {
        event.getSuppliedResponse().getWriter().println("in onStartAsync method of TestListener2");
    }

    public void onComplete(AsyncEvent event) throws IOException {
        event.getSuppliedResponse().getWriter().println("in onComplete method of TestListener2");
    }

    public void onTimeout(AsyncEvent event) throws IOException {
        event.getSuppliedResponse().getWriter().println("in onTimeout method of TestListener2");
    }
}
