/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id:$
 */
package com.sun.ts.tests.servlet.api.javax_servlet.servletcontext301;

import com.sun.ts.tests.servlet.common.servlets.GenericTCKServlet;
import com.sun.ts.tests.servlet.common.util.ServletTestUtil;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class TestServlet extends GenericTCKServlet {

    public void addListenerTest(ServletRequest request, ServletResponse response)
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();

        String name = "LISTENER_TEST";

        pw.println(name + "=" + getServletContext().getInitParameter(name).
                toUpperCase());
        getServletContext().removeAttribute(name);

        ServletTestUtil.printResult(pw, true);
        getServletContext().removeAttribute("arraylist");
    }
}
