/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestServlet.java 62571 2011-04-18 20:58:13Z kgrucci $
 */

package com.sun.ts.tests.servlet.api.javax_servlet.servletexception;

import com.sun.ts.tests.servlet.common.servlets.GenericTCKServlet;
import com.sun.ts.tests.servlet.common.util.ServletTestUtil;

import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import java.io.IOException;
import java.io.PrintWriter;


public class TestServlet extends GenericTCKServlet {


    public void getRootCause(ServletRequest request, ServletResponse response)
        throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        ServletException se = new ServletException(new Throwable("cause"));

        if (se.getRootCause() instanceof Throwable) {
            passed = true;
        } else {
            passed = false;
            pw.println("ServletException.getRootCause() did not thrown an instance of Throwable");
        }
        ServletTestUtil.printResult(pw, passed);

    }

    public void servletExceptionConstructor1(ServletRequest request, ServletResponse response)
        throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        // construct and throw
        try {
            throw new ServletException();
        } catch (Throwable t) { // catching it here itself
            if (t instanceof ServletException) {
                passed = true;
            } else {
                passed = false;
                pw.println("Exception thrown was not of type ServletException");
            }
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void servletExceptionConstructor2(ServletRequest request, ServletResponse response)
        throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;

        try {
            throw new ServletException("Exceptional");
        } catch (Throwable t) {
            if (t instanceof ServletException) {
                if (t.getMessage().equals("Exceptional")) {
                    passed = true;
                } else {
                    passed = false;
                    pw.println("Exception did not contain Exceptional");
                }
            } else {
                passed = false;
                pw.println("Exception thrown was not of type ServletException(String)");
            }
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void servletExceptionConstructor3(ServletRequest request, ServletResponse response)
        throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        ServletException se = null;

        //construct one and throw
        try {
            se = new ServletException(new Throwable("irrelevant"));
            throw se;
        } catch (Throwable t) {
            if (t instanceof ServletException) {
                Throwable rootCause = se.getRootCause();

                if (rootCause != null) {
                    if (rootCause.getMessage().equals("irrelevant")) {
                        passed = true;
                    } else {
                        passed = false;
                        pw.println("Exception did not contain irrelevant");
                    }
                } else {
                    passed = false;
                    pw.println("rootCause message is null, expecting it to be 'irrelevant'");
                }

            } else {
                passed = false;
                pw.println("Exception thrown is not of type ServletException");
            }
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void servletExceptionConstructor4(ServletRequest request, ServletResponse response)
        throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        ServletException se = null;

        //construct and throw
        try {
            se = new ServletException("Exceptional", new Throwable("cos"));
            throw se;
        } catch (Throwable t) {
            if (t instanceof ServletException) {
                Throwable cause = se.getRootCause();
                String mesg = se.getMessage();

                if (cause != null && mesg != null) {
                    if (mesg.equals("Exceptional") && cause.getMessage().equals("cos")) {
                        passed = true;
                    } else {
                        passed = false;
                        pw.println("Exception did not contain Exceptional and a cause of cos");
                        pw.println("Actual exception was |" + mesg + "|");
                        pw.println("Actual cause was |" + cause.getMessage() + "|");
                    }
                } else {
                    passed = false;
                    pw.println("rootCause message thrown by Exception was null");
                }
            } else {
                passed = false;
                pw.println("Exception thrown was not an instance of ServletException");
            }
        }
        ServletTestUtil.printResult(pw, passed);
    }
}
