/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id:$
 */
package com.sun.ts.tests.servlet.api.javax_servlet.servletrequest30;

import com.sun.ts.tests.servlet.common.servlets.GenericTCKServlet;
import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class AsyncTestServlet extends GenericTCKServlet {

    public void getDispatcherTypeTestAsync(ServletRequest request,
            ServletResponse response) {
        String path = "/async/AsyncTests?testname=getDispatcherTypeTest";
        AsyncContext ac = request.startAsync();
        ac.dispatch(path);
    }

    public void asyncStartedTest1(ServletRequest request,
            ServletResponse response) throws IOException {
        AsyncContext ac = request.startAsync();
        response.getWriter().println("IsAsyncStarted=" +
                request.isAsyncStarted());
        ac.complete();
    }

    public void asyncStartedTest2(ServletRequest request,
            ServletResponse response) throws IOException {
        response.getWriter().println("IsAsyncStarted=" +
                request.isAsyncStarted());
    }

    public void asyncStartedTest3(ServletRequest request,
            ServletResponse response) throws IOException {
        AsyncContext ac = request.startAsync();
        ac.complete();
        response.getWriter().println("IsAsyncStarted=" +
                request.isAsyncStarted());
    }

    public void asyncStartedTest4(ServletRequest request,
            ServletResponse response) {
        String path = "/async/AsyncTests?testname=isAsyncStartedTest";
        AsyncContext ac = request.startAsync();
        ac.dispatch(path);
    }

    public void isAsyncSupportedTest(ServletRequest request,
            ServletResponse response) throws IOException {
        response.getWriter().println("isAsyncSupported=" +
                request.isAsyncSupported());
    }

    public void startAsyncTest(ServletRequest request,
            ServletResponse response) throws IOException {
        String path = "/async/AsyncTests?testname=getDispatcherTypeTest";
        AsyncContext ac = request.startAsync();
        ac.dispatch(path);
        try {
            request.startAsync();
            response.getWriter().println("Expected IllegalStateException not thrown in AsyncTestServlet#startAsyncTest. Test FAILED.");
        } catch (IllegalStateException ise) {
            response.getWriter().println("Expected IllegalStateException thrown in AsyncTestServlet#startAsyncTest. Test PASSED.");
        }
    }

    public void getAsyncContextTest(ServletRequest request,
            ServletResponse response) throws IOException {
        AsyncContext ac = request.startAsync();
        AsyncContext ac1 = request.getAsyncContext();
        if (ac != ac1) {
            response.getWriter().println("getAsyncContext returned is different. Test FAILED.");
        } else {
            response.getWriter().println("getAsyncContext returned is correct. Test PASSED.");
        }
        ac.complete();
    }
}
