/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */
package com.sun.ts.tests.servlet.api.javax_servlet.sessiontrackingmode4;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.SessionTrackingMode;

public class TestListener implements ServletContextListener {

    /**
     * Receives notification that the web application initialization
     * process is starting.
     *
     * @param sce The ServletContextEvent
     */
    public void contextInitialized(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        StringBuilder log = new StringBuilder();

        List<SessionTrackingMode> complete = new CopyOnWriteArrayList<SessionTrackingMode>();
        complete.add(SessionTrackingMode.COOKIE);
        complete.add(SessionTrackingMode.SSL);
        complete.add(SessionTrackingMode.URL);

        Set<SessionTrackingMode> complete_set = new HashSet(complete);

        try {
            context.setSessionTrackingModes(complete_set);
            log.append("Expected IllegalArgumentException not thrown.");
        } catch (IllegalArgumentException ex) {
            log.append("Expected IllegalArgumentException thrown.");
        }

        context.setAttribute("TCK_TEST_STATUS", log.toString());
    }

    /**
     * Receives notification that the servlet context is about to be shut down.
     *
     * @param sce The servlet context event
     */
    public void contextDestroyed(ServletContextEvent sce) {
        // Do nothing
    }
}
