/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.servlet.api.javax_servlet_http.httpservletresponse40;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class TrailerTestServlet2 extends HttpServlet {
  @Override
  protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    String s = "Get IllegalStateException when call setTrailerFields";
    resp.setHeader("Content-Length", String.valueOf(s.length()));
    Writer writer = resp.getWriter();
    writer.flush();
    try {
      resp.setTrailerFields(() -> {
        Map m = new HashMap();
        m.put("myTrailer", "foo");
        return m;
      });
      writer.write("Current trailer field: ");
      resp.getTrailerFields().get().forEach((key, value) -> {
        try {writer.write(key + ":" + value);} catch(IOException e) {throw new RuntimeException(e);}});
    } catch (IllegalStateException e) {
      writer.write(s);
    }
  }
}
