/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id:$
 */
package com.sun.ts.tests.servlet.spec.annotationservlet.webfilter;

import com.sun.ts.tests.servlet.common.util.ServletTestUtil;
import com.sun.ts.tests.servlet.common.util.StaticLog;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

@WebServlet(value = "/Servlet1", name = "servlet1")
public class Servlet1 extends HttpServlet {

    public void service(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();

        ArrayList result = StaticLog.getClear();
        if (result != null) {
            for (Object tmp : result) {
                if (tmp != null) {
                    pw.println(tmp.toString());
                    System.out.println(tmp.toString());
                }
            }
        }
        StaticLog.clear();

        pw.write("Servlet1_INVOKED");
        ServletTestUtil.printResult(pw, true);
    }
}
