/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */
package com.sun.ts.tests.servlet.spec.annotationservlet.webfilter;

import com.sun.ts.tests.servlet.common.util.StaticLog;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;


@WebFilter(filterName = "filter2", dispatcherTypes = {DispatcherType.FORWARD}, 
        servletNames = {"servlet1"}, value = {"/Servlet1"}, 
        initParams={@WebInitParam(name = "name1", value = "value1"),
        @WebInitParam(name = "name2", value = "value2")}
)
        
public final class TestFilter2 implements Filter {

    private FilterConfig filterConfig = null;

    public void doFilter(ServletRequest request, ServletResponse response,
            FilterChain chain) throws IOException, ServletException {

        if (filterConfig == null) {
            StaticLog.add("FAILED_FILTER2_INVOKED");
        } else {
            StaticLog.add("FILTER2_INVOKED");
            StaticLog.add("FilterName=" + filterConfig.getFilterName());

            for (Enumeration names = filterConfig.getInitParameterNames();
                    names.hasMoreElements();) {
                String name = (String) names.nextElement();
                StaticLog.add("PName=" + name + " PVALUE=" +
                        filterConfig.getInitParameter(name));
            }
            StaticLog.add("AsyncSupport=" + request.isAsyncSupported());
            FilterRegistration fr = filterConfig.getServletContext().
                    getFilterRegistration(filterConfig.getFilterName());
            Collection<String> mapping = fr.getServletNameMappings();
            for (String url : mapping) {
                StaticLog.add("URL=" + url);
            }
            StaticLog.add("DispatcherType=" + request.getDispatcherType());
            StaticLog.add("From=" + request.getAttribute("from"));
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }
}
