/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id:$
 */
package com.sun.ts.tests.servlet.spec.annotationservlet.weblistener;

import java.util.ArrayList;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

@WebListener("HttpSessionListener")
public final class HSListener implements HttpSessionListener {

    public void sessionCreated(HttpSessionEvent event) {
        ArrayList al = null;
        al =
                (ArrayList) event.getSession().getServletContext().getAttribute("HSList");
        if (al == null) {
            al = new ArrayList();
        }
        al.add("HSListener:sessionCreated");
        event.getSession().getServletContext().setAttribute("HSList", al);
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        ArrayList al = null;
        al =
                (ArrayList) event.getSession().getServletContext().getAttribute("HSList");
        if (al == null) {
            al = new ArrayList();
        }
        al.add("HSListener:sessionDestroyed");
        event.getSession().getServletContext().setAttribute("HSList", al);
    }
}
