/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id:$
 */
package com.sun.ts.tests.servlet.spec.annotationservlet.weblistener;

import java.util.ArrayList;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.annotation.WebListener;

@WebListener(value = "ServletRequestAttributeListener")
public final class SRAttributeListener implements ServletRequestAttributeListener {


      public void attributeAdded(ServletRequestAttributeEvent event) {
        ArrayList al = null;
        al = (ArrayList) event.getServletContext().getAttribute("SRAList");
        if (al == null) {
            al = new ArrayList();
        }
        al.add("SRAAdded:" + event.getName() + "," + event.getValue());
        event.getServletContext().setAttribute("SRAList", al);
    }

    public void attributeRemoved(ServletRequestAttributeEvent event) {
        ArrayList al = null;
        al = (ArrayList) event.getServletContext().getAttribute("SRAList");
        if (al == null) {
            al = new ArrayList();
        }
        al.add("SRARemoved:" + event.getName() + "," + event.getValue());
        event.getServletContext().setAttribute("SRAList", al);
    }

    public void attributeReplaced(ServletRequestAttributeEvent event) {
        ArrayList al = null;
        al = (ArrayList) event.getServletContext().getAttribute("SRAList");
        if (al == null) {
            al = new ArrayList();
        }
        al.add("SRAReplaced:" + event.getName() + "," + event.getValue());
        event.getServletContext().setAttribute("SRAList", al);
    }
}
