/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id:$
 */
package com.sun.ts.tests.servlet.spec.annotationservlet.weblistener;

import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import java.util.ArrayList;
import javax.servlet.annotation.WebListener;

@WebListener(value = "ServletRequestListener")
public final class SRListener implements ServletRequestListener {

    public void requestDestroyed(ServletRequestEvent event) {
        ArrayList al = null;
        al = (ArrayList) event.getServletContext().getAttribute("SRList");
        if (al == null) {
            al = new ArrayList();
        }

        al.add("in requestDestroyed method of listener");
        event.getServletContext().setAttribute("SRList", al);
    }

    public void requestInitialized(ServletRequestEvent event) {
        ArrayList al = null;
        al = (ArrayList) event.getServletContext().getAttribute("SRList");
        if (al == null) {
            al = new ArrayList();
        }

        al.add("in requestInitialized method of listener");
        event.getServletContext().setAttribute("SRList", al);
    }
}
