/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: ForwardedServlet.java 52684 2007-02-12 04:30:10Z lschwenk $
 */
package com.sun.ts.tests.servlet.spec.requestdispatcher;

import com.sun.ts.tests.servlet.common.servlets.GenericTCKServlet;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.RequestDispatcher;

public class MultiForwardedServlet extends GenericTCKServlet {

    private static final String TEST_HEADER = "testname";
    private static final Class[] TEST_ARGS = {ServletRequest.class,
        ServletResponse.class
    };
    private static final String TEST1_HEADER = "TestName";

    public void service(ServletRequest request, ServletResponse response)
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        
        String path = "/forward/ForwardedServlet?testname=attributes&query=forwardAttributes6";
        RequestDispatcher rd = request.getRequestDispatcher(path);

        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            rd.forward(request, response);
        }
    }
}
