/*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: ServletSecTestServlet.java 67501 2012-09-06 20:10:22Z phendley $
 */

package com.sun.ts.tests.servlet.spec.security.secbasic;


import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;


public class ServletSecTestServlet extends HttpServlet {


    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {


        PrintWriter out = response.getWriter();

        System.out.println("Inside  ServletSecTestServlet ....." + "<BR>");
        System.out.println("The user principal is: " + request.getUserPrincipal().getName() + "<BR>");
        System.err.println("The user principal is: " + request.getUserPrincipal().getName() + "<BR>");
        
        out.println("The user principal is: " + request.getUserPrincipal().getName() + "<BR>");
        out.println("getRemoteUser(): " + request.getRemoteUser() + "<BR>");

        out.println("Inside  ServletSecTestServlet ....." + "<BR>");  // used for validating test7

        // Surround these with !'s so they are easier to search for.
        // (i.e. we can search for !true! or !false!)
        out.println("isUserInRole(\"ADM\"): !" + request.isUserInRole("ADM") + "!<BR>");
        out.println("isUserInRole(\"MGR\"): !" + request.isUserInRole("MGR") + "!<BR>");
        out.println("isUserInRole(\"VP\"): !" + request.isUserInRole("VP") + "!<BR>");
        out.println("isUserInRole(\"EMP\"): !" + request.isUserInRole("EMP") + "!<BR>");
        out.println("isUserInRole(\"Administrator\"): !" + request.isUserInRole("Administrator") + "!<BR>");

    }
}

