/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: ForwardedServlet.java 62571 2011-04-18 20:58:13Z kgrucci $
 */

package com.sun.ts.tests.servlet.spec.security.secform;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

public class ForwardedServlet extends HttpServlet {


    public void service(HttpServletRequest request,
                        HttpServletResponse response)
        throws ServletException, IOException {

        PrintWriter out = response.getWriter();
        response.setContentType("text/html");

        //HttpSession session = request.getSession(true);
        //session.setAttribute("ForwardedServletAttribute", "100");
        //out.println("HttpSession Id :"+ session.getId());


        //Note: The request to ControlServlet was already forwarded
        //      to ForwardedServlet
        out.println("\n\nContents From ForwardedServlet");
        out.println("Using RequestDispatcher's forward() method the request " +
            "for ControlServlet was forwarded to ForwardedServlet");
        out.println("From ForwardedServlet: getRemoteUser(): " +
            request.getRemoteUser() + "<BR>");
        out.println("From ForwardedServlet: isUserInRole(\"Administrator\"): !" +
            request.isUserInRole("Administrator") + "!<BR>");

        //Include "IncludedServlet" through request dispatcher's include() method
        out.println("\nIncluding the responses from IncludedServlet \n");

        String path = "/IncludedServlet";
        RequestDispatcher requestDispatcher =
            getServletContext().getRequestDispatcher(path);
        requestDispatcher.include(request, response);


    }
}

