/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.servlet.spec.serverpush;

import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.PushBuilder;
import java.io.IOException;
import java.io.PrintWriter;

public class TestServlet2 extends HttpServlet {

  @Override
  protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    PrintWriter pw = resp.getWriter();
    req.getSession(true);
    PushBuilder pb = req.newPushBuilder();
    String defaultMethod = pb.getMethod();
    pw.println("Method:" + defaultMethod);
    PushBuilder pb2 = req.newPushBuilder();
    pw.println("Return new instance:" + String.valueOf(pb!=pb2));
    pw.println("JSESSIONID: " + pb.getSessionId());
    pw.println("The headers of PushBuilder: ");
    for(String name : pb.getHeaderNames()) {
      pw.print(name);
      pw.print("=");
      pw.println(pb.getHeader(name));
    }
  }
}
