/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: ApacheRequestAdapter.java 72390 2013-07-26 08:41:02Z supol $
 */

package com.sun.ts.tests.websocket.common.client;

import com.sun.ts.tests.common.webclient.http.HttpRequest;

public class ApacheRequestAdapter extends HttpRequest {

	public ApacheRequestAdapter(String protocol, String requestLine,
			String host, int port) {
		super("GET " + requestLine.replace(protocol + "://", "http://")
				+ " HTTP/1.1", host, port);
	}

	/**
	 * <code>getRequestPath</code> returns the request path for this particular
	 * request.
	 * 
	 * @return String request path
	 */
	public String getRequestPath() {
		return super.getRequestPath();
	}

}
