/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: ClientConfiguratorHolderClientConfigurator.java 72743 2013-08-28 17:30:13Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.clientendpoint;

import com.sun.ts.tests.websocket.common.impl.ClientConfigurator;

/**
 * The findbugs compliant ClientConfigurator accessible out of WebSocket impl
 */
public class ClientConfiguratorHolderClientConfigurator extends
		ClientConfigurator {
	private static ClientConfigurator configurator;

	public ClientConfiguratorHolderClientConfigurator() {
		super();
		ClientConfiguratorHolderClientConfigurator.setConfigurator(this);
	}

	static ClientConfigurator getConfigurator() {
		return configurator;
	}

	private static void setConfigurator(ClientConfigurator configurator) {
		ClientConfiguratorHolderClientConfigurator.configurator = configurator;
	}
}
