/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSCLoggerServer.java 72680 2013-08-26 15:08:29Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.coder;

import java.io.IOException;

import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.common.util.IOUtil;

@ServerEndpoint("/logger")
public class WSCLoggerServer {

	@OnMessage
	public String echo(String operation) {
		return operation(operation);
	}

	public static String operation(String operation) {
		String ret = operation;
		if (operation.equals("clearinit"))
			Logger.clearInitLog();
		else if (operation.equals("cleardestroy"))
			Logger.clearDestroyLog();
		else if (operation.equals("getinit"))
			ret = Logger.getInitLog();
		else if (operation.equals("getdestroy"))
			ret = Logger.getDestroyLog();
		else if (operation.equals("getcode"))
			ret = Logger.getCodeLog();
		else if (operation.equals("getwillcode"))
			ret = Logger.getWillCodeLog();
		else if (operation.equals("clearall")) {
			Logger.clearInitLog();
			Logger.clearDestroyLog();
			Logger.clearCodeLog();
			Logger.clearWillCodeLog();
		}
		return ret;
	}

	@OnError
	public void onError(Session session, Throwable t) throws IOException {
		System.out.println("@OnError in" + getClass().getName());
		t.printStackTrace(); // Write to error log, too
		String message = IOUtil.printStackTrace(t);
		session.getBasicRemote().sendText(message);
	}

}
