/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSCCloseClientEndpoint.java 73505 2014-02-20 18:26:15Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.endpoint.client;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.client.StringClientEndpoint;

public class WSCCloseClientEndpoint extends StringClientEndpoint {
	boolean onCloseCalled = false;
	private CountDownLatch countDown = new CountDownLatch(1);

	@Override
	public void onMessage(String msg) {
		super.onMessage(msg);
	}

	@Override
	public void onOpen(Session session, EndpointConfig config) {
		super.onOpen(session, config);
	}

	@Override
	public void onClose(Session session, CloseReason closeReason) {
		super.onClose(session, closeReason);
		onCloseCalled = true;
		countDown.countDown();
	}

	public void onError(Session session, Throwable t) {
		super.onError(session, t);
	}

	public void waitForClose(long seconds) {
		try {
			countDown.await(seconds, TimeUnit.SECONDS);
		} catch (InterruptedException e) {
			throw new RuntimeException(e);
		}
	}

}
