/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder.basic;

import java.io.IOException;

import javax.websocket.EncodeException;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder.TextCoderBool;
import com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder.TextCoderByte;
import com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder.TextCoderChar;
import com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder.TextCoderDouble;
import com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder.TextCoderFloat;
import com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder.TextCoderInt;
import com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder.TextCoderLong;
import com.sun.ts.tests.websocket.ee.javax.websocket.remoteendpoint.usercoder.TextCoderShort;

@ServerEndpoint(value = "/text", encoders = { TextCoderBool.class,
		TextCoderByte.class, TextCoderChar.class, TextCoderDouble.class,
		TextCoderInt.class, TextCoderLong.class, TextCoderFloat.class,
		TextCoderShort.class })
public class WSCTextServer extends WSCCommonServer {

	@OnMessage
	public void onMessage(String msg, Session session) throws IOException,
			EncodeException {
		super.onMessage(msg, session);
	}

	@OnError
	public void onError(Session session, Throwable t) throws IOException {
		super.onError(session, t);
	}
}
