/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: GetEndpointInstanceConfigurator.java 72735 2013-08-28 16:38:40Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.server.serverendpointconfig.configurator;

import javax.websocket.server.ServerEndpointConfig.Configurator;

public class GetEndpointInstanceConfigurator extends Configurator {
	private static String instanceName;
	static final String ADDITIONAL_INFORMATION = "Additional information passed to instance";

	@SuppressWarnings("unchecked")
	@Override
	public <T> T getEndpointInstance(Class<T> endpointClass)
			throws InstantiationException {
		T t = super.getEndpointInstance(endpointClass);
		GetEndpointInstanceConfigurator.setInstanceName(t.getClass().getName());
		if (endpointClass == WSCGetEndpointInstanceServer.class)
			t = (T) new WSCGetEndpointInstanceServer(ADDITIONAL_INFORMATION);
		return t;
	}

	static String getInstanceName() {
		return instanceName;
	}

	static void setInstanceName(String instanceName) {
		GetEndpointInstanceConfigurator.instanceName = instanceName;
	}
}
