/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: ByteBufferPartialMessageHandler.java 73930 2014-08-01 17:07:43Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.session11.client;

import java.nio.ByteBuffer;

import javax.websocket.MessageHandler;

import com.sun.ts.tests.websocket.common.client.ClientEndpoint;
import com.sun.ts.tests.websocket.common.util.IOUtil;

public class ByteBufferPartialMessageHandler implements
		MessageHandler.Partial<ByteBuffer> {

	ClientEndpoint<String> endpoint;
	public static final String HANDLER_SAYS = "ByteBufferPartialMessageHandler says: ";
	StringBuilder sb = new StringBuilder();

	public ByteBufferPartialMessageHandler(ClientEndpoint<String> endpoint) {
		super();
		this.endpoint = endpoint;
	}

	@Override
	public void onMessage(ByteBuffer message, boolean finite) {
		sb.append(IOUtil.byteBufferToString(message));
		if (finite)
			endpoint.onMessage(HANDLER_SAYS + sb.toString());
	}
}
