/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: ByteArrayMessageHandler.java 73928 2014-08-01 09:35:37Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.session11.server;

import java.io.IOException;

import javax.websocket.MessageHandler;
import javax.websocket.Session;

public class ByteArrayMessageHandler implements MessageHandler.Whole<byte[]> {

	private Session session;
	public static final String HANDLER_SAYS = "ByteArrayMessageHandler says: ";

	public ByteArrayMessageHandler(Session session) {
		super();
		this.session = session;
	}

	@Override
	public void onMessage(byte[] message) {
		try {
			session.getBasicRemote().sendText(
					HANDLER_SAYS + new String(message));
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}
}
