/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSCTextEncoderServer.java 72876 2013-09-17 12:05:52Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.throwingcoder.annotated;

import java.io.IOException;

import javax.websocket.EncodeException;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.common.stringbean.StringBean;
import com.sun.ts.tests.websocket.ee.javax.websocket.throwingcoder.ThrowingTextDecoder;
import com.sun.ts.tests.websocket.ee.javax.websocket.throwingcoder.ThrowingTextEncoder;

@ServerEndpoint(value = "/textencoder", encoders = { ThrowingTextEncoder.class })
public class WSCTextEncoderServer {

	@OnMessage
	public void echo(String data, Session session) throws IOException, EncodeException {
		session.getBasicRemote().sendObject(new StringBean(data));
	}

	@OnError
	public void onError(Session session, Throwable t) throws IOException {
		String message = ThrowingTextDecoder.getCauseMessage(t);
		session.getBasicRemote().sendText(message);
	}

}
