/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSPrimitiveByteServer.java 70358 2013-02-28 19:59:40Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.websocketmessagereturntype;

import java.io.IOException;

import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.common.util.IOUtil;

@ServerEndpoint("/primitivebyte")
public class WSPrimitiveByteServer {
	@OnMessage
	public byte echo(String data) {
		return Byte.parseByte(data);
	}

    @OnError
    public void onError(Session session, Throwable t) throws IOException {
    	t.printStackTrace(); //Write to error log, too
    	String message = "Exception: " + IOUtil.printStackTrace(t);
    	session.getBasicRemote().sendText(message);
    }	
}
