/*
 * Copyright (c) 2015, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSCClient.java 74522 2015-06-02 12:05:10Z jsupol $
 */
package com.sun.ts.tests.websocket.negdep.invalidpathparamtype.pasrv.onclose;

import com.sun.ts.tests.websocket.negdep.NegativeDeploymentClient;

/*
 * @class.setup_props: webServerHost;
 *                     webServerPort;
 *                     ts_home;
 *                     ws_wait;
 *                     tslib.name;
 */
/**
 * @since 1.11
 */
public class WSCClient extends NegativeDeploymentClient {

	private static final long serialVersionUID = 111L;

	public WSCClient() {
		setContextRoot("wsc_negdep_invalidpathparamtype_pasrv_onclose_web");
	}

	public static void main(String[] args) {
		new WSCClient().run(args);
	}

	/*
	 * @testName: invalidTypeOnCloseUndeployOtherEndpointTest
	 * @assertion_ids:  WebSocket:SPEC:WSC-5.2.1-3;WebSocket:SPEC:WSC-4.3-1;
	 * @test_Strategy: In both cases, a deployment error raised during the 
	 * deployment process must halt the deployment of the application, any 
	 * well formed endpoints deployed prior to the error being raised must be 
	 * removed from service and no more websocket endpoints from that 
	 * application may be deployed by the container, even if they are valid.
	 * 
	 * The allowed types for these parameters are String, any Java primitive 
	 * type, or boxed version thereof. Any other type annotated with this 
	 * annotation is an error that the implementation must report at 
	 * deployment time. [WSC-4.3-1]
	 * 
	 * To verify the test fails when the deployment was successful, switch 
	 * StringHolder to String as argument of @OnClose in 
	 * OnCloseStringHolderServerEndpoint 
	 */
	public void invalidTypeOnCloseUndeployOtherEndpointTest() throws Fault {
		setProperty(Property.CONTENT, "anything");
		setProperty(Property.REQUEST, buildRequest("echo"));
		setProperty(Property.STATUS_CODE, "-1");
		// logExceptionOnInvocation(false);
		try {
			invoke(false);
		} catch (Fault tfe) {
			// DeploymentException
		}
		String response = getResponseAsString();
		if ("anything".equals(response))
			throwValidEndpointMustBeRemoved();
	}

	/*
	 * @testName: invalidTypeOnCloseTest
	 * @assertion_ids:  WebSocket:SPEC:WSC-5.2.1-3;WebSocket:SPEC:WSC-4.3-1;
	 * @test_Strategy: In both cases, a deployment error raised during the 
	 * deployment process must halt the deployment of the application, any 
	 * well formed endpoints deployed prior to the error being raised must be 
	 * removed from service and no more websocket endpoints from that 
	 * application may be deployed by the container, even if they are valid.
	 * 
	 * The allowed types for these parameters are String, any Java primitive 
	 * type, or boxed version thereof. Any other type annotated with this 
	 * annotation is an error that the implementation must report at 
	 * deployment time. [WSC-4.3-1]
	 * 
	 * To verify the test fails when the deployment was successful, switch 
	 * StringHolder to String as argument of @OnClose in 
	 * OnCloseStringHolderServerEndpoint
	 */
	public void invalidTypeOnCloseTest() throws Fault {
		setProperty(Property.CONTENT, "anything");
		setProperty(Property.REQUEST, buildRequest("invalid/pathparam"));
		setProperty(Property.STATUS_CODE, "-1");
		// logExceptionOnInvocation(false);
		try {
			invoke(false);
		} catch (Fault tfe) {
			// DeploymentException
		}
		String response = getResponseAsString();
		if (response.contains("anything"))
			throwValidEndpointMustBeRemoved();
	}
}
