/*
 * Copyright (c) 2015, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: EchoServerEndpoint.java 74522 2015-06-02 12:05:10Z jsupol $
 */

package com.sun.ts.tests.websocket.negdep.onmessage.ppsrv.nomoreendpoints;

import java.io.IOException;

import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.util.IOUtil;

public class EchoServerEndpoint extends Endpoint implements
		MessageHandler.Whole<String> {
	private Session session;

	@Override
	public void onOpen(Session session, EndpointConfig config) {
		this.session = session;
		session.addMessageHandler(this);
	}

	@Override
	public void onMessage(String message) {
		try {
			session.getBasicRemote().sendText(message);
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}
	
	@Override
	public void onError(Session session, Throwable thr) {
		thr.printStackTrace(); // Write to error log, too
		String message = IOUtil.printStackTrace(thr);
		try {
			session.getBasicRemote().sendText(message);
		} catch (IOException e) {
			e.printStackTrace();
		}		
	}

}
