/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.core.multivaluedhashmap;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.AbstractMultivaluedMap;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = -4827869994556677693L;
    static final String[] VALUES = new String[]{"value1", "value2", "value3", "value4", "value5"};

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void defaultConstructorTest() throws JAXRSCommonClient.Fault {
        MultivaluedHashMap map = new MultivaluedHashMap();
        map.addAll((Object)"key", (Object[])new String[]{VALUES[0], VALUES[1], VALUES[2]});
        JAXRSClientIT.assertContainsDefaultValues((AbstractMultivaluedMap<String, String>)map);
        JAXRSClientIT.assertNotContains((AbstractMultivaluedMap<String, String>)map, "key", VALUES[3], VALUES[4]);
    }

    @Test
    public void constructorWithInitialCapacityTest() throws JAXRSCommonClient.Fault {
        MultivaluedHashMap map = new MultivaluedHashMap(0);
        map.addAll((Object)"key", (Object[])new String[]{VALUES[0], VALUES[1], VALUES[2]});
        JAXRSClientIT.assertContainsDefaultValues((AbstractMultivaluedMap<String, String>)map);
        JAXRSClientIT.assertNotContains((AbstractMultivaluedMap<String, String>)map, "key", VALUES[3], VALUES[4]);
    }

    @Test
    public void constructorWithInitialCapacityThrowsIllegalArgumentExceptionTest() throws JAXRSCommonClient.Fault {
        try {
            new MultivaluedHashMap(-1);
            throw new JAXRSCommonClient.Fault("IllegalArgumentException has not been thrown");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected");
            return;
        }
    }

    @Test
    public void constructorWithCapacityAndLoadTest() throws JAXRSCommonClient.Fault {
        MultivaluedHashMap map = new MultivaluedHashMap(0, 0.99f);
        map.addAll((Object)"key", (Object[])new String[]{VALUES[0], VALUES[1], VALUES[2]});
        JAXRSClientIT.assertContainsDefaultValues((AbstractMultivaluedMap<String, String>)map);
        JAXRSClientIT.assertNotContains((AbstractMultivaluedMap<String, String>)map, "key", VALUES[3], VALUES[4]);
    }

    @Test
    public void constructorWithCapacityAndLoadThrowsExceptionForCapacityTest() throws JAXRSCommonClient.Fault {
        try {
            new MultivaluedHashMap(Integer.MIN_VALUE, 0.99f);
            throw new JAXRSCommonClient.Fault("IllegalArgumentException has not been thrown");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected");
            return;
        }
    }

    @Test
    public void constructorWithCapacityAndLoadThrowsExceptionForLoadTest() throws JAXRSCommonClient.Fault {
        try {
            new MultivaluedHashMap(16, 0.0f);
            throw new JAXRSCommonClient.Fault("IllegalArgumentException has not been thrown");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected");
            return;
        }
    }

    @Test
    public void constructorWithMapTest() throws JAXRSCommonClient.Fault {
        MultivaluedHashMap map = new MultivaluedHashMap();
        map.addAll((Object)"key", (Object[])new String[]{VALUES[0], VALUES[1], VALUES[2]});
        MultivaluedHashMap mapWithMap = new MultivaluedHashMap((MultivaluedMap)map);
        JAXRSClientIT.assertContainsDefaultValues((AbstractMultivaluedMap<String, String>)mapWithMap);
        mapWithMap.clear();
        JAXRSClientIT.assertContainsDefaultValues((AbstractMultivaluedMap<String, String>)map);
        mapWithMap = new MultivaluedHashMap((MultivaluedMap)map);
        map.clear();
        JAXRSClientIT.assertContainsDefaultValues((AbstractMultivaluedMap<String, String>)mapWithMap);
    }

    @Test
    public void constructorWithMapThrowsNPETest() throws JAXRSCommonClient.Fault {
        try {
            new MultivaluedHashMap((MultivaluedMap)null);
            throw new JAXRSCommonClient.Fault("NullPointerException has NOT been thrown");
        }
        catch (NullPointerException e) {
            JAXRSClientIT.logMsg("NullPointerException has been thrown as expected");
            return;
        }
    }

    @Test
    public void constructorWithSingleValuedMapTest() throws JAXRSCommonClient.Fault {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", VALUES[0]);
        MultivaluedHashMap mapWithMap = new MultivaluedHashMap(map);
        JAXRSClientIT.assertContains((MultivaluedMap<String, String>)mapWithMap, "key", VALUES[0]);
        mapWithMap.clear();
        Assertions.assertTrue((map.size() == 1 ? 1 : 0) != 0, (String)"The original map is empty after MultivaluedHashMap#clear()");
        mapWithMap = new MultivaluedHashMap(map);
        map.clear();
        JAXRSClientIT.assertContains((MultivaluedMap<String, String>)mapWithMap, "key", VALUES[0]);
    }

    @Test
    public void constructorWithSingleValuedMapThrowsNPETest() throws JAXRSCommonClient.Fault {
        try {
            new MultivaluedHashMap((Map)null);
            throw new JAXRSCommonClient.Fault("NullPointerException has NOT been thrown");
        }
        catch (NullPointerException e) {
            JAXRSClientIT.logMsg("NullPointerException has been thrown as expected");
            return;
        }
    }

    protected static void assertContainsDefaultValues(AbstractMultivaluedMap<String, String> map) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertContains(map, "key", new String[]{VALUES[0], VALUES[1], VALUES[2]});
    }

    protected static void assertContains(MultivaluedMap<String, String> map, String key, String ... values) throws JAXRSCommonClient.Fault {
        List list = (List)map.get((Object)key);
        for (String item : values) {
            Assertions.assertTrue((boolean)list.contains(item), (String)("Given map does not contain value " + item));
        }
        JAXRSClientIT.logMsg("Found key", key, "with following values:");
        JAXRSClientIT.logMsg(values);
    }

    protected static void assertNotContains(AbstractMultivaluedMap<String, String> map, String key, String ... values) throws JAXRSCommonClient.Fault {
        List list = map.get((Object)key);
        if (list != null) {
            for (String item : values) {
                Assertions.assertTrue((!list.contains(item) ? 1 : 0) != 0, (String)("Given map does contain value " + item));
            }
        }
        JAXRSClientIT.logMsg("For given", key, "the map does not contain following values as expected:");
        JAXRSClientIT.logMsg(values);
    }
}

