/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.jaxrs21.ee.sse.sseeventsource;

import ee.jakarta.tck.ws.rs.common.impl.JaxbKeyValueBean;
import ee.jakarta.tck.ws.rs.common.impl.SinglevaluedMap;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.sse.Sse;
import jakarta.ws.rs.sse.SseEventSink;
import jakarta.xml.bind.JAXBElement;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

@Path(value="media")
public class MediaTypeResource {
    private static MediaType mediaType = MediaType.WILDCARD_TYPE;
    private static final Logger LOG = Logger.getLogger(MediaTypeResource.class.getName());

    @POST
    @Path(value="set")
    public String setMediaType(String media) {
        String[] split = media.split("/", 2);
        mediaType = new MediaType(split[0], split[1]);
        return media;
    }

    @GET
    @Path(value="data")
    @Produces(value={"text/event-stream"})
    public void sendData(@Context SseEventSink sink, @Context Sse sse) {
        try (SseEventSink s = sink;){
            s.send(sse.newEventBuilder().data((Object)"some_ServiceUnavailableEndpoint_message").mediaType(mediaType).build());
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Failed to close SseEventSink", e);
        }
    }

    @GET
    @Path(value="jaxb")
    @Produces(value={"text/event-stream"})
    public void sendJAXB(@Context SseEventSink sink, @Context Sse sse) {
        try (SseEventSink s = sink;){
            JAXBElement element = new JAXBElement(new QName("name"), String.class, (Object)"some_ServiceUnavailableEndpoint_message");
            s.send(sse.newEventBuilder().data((Object)element).mediaType(mediaType).build());
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Failed to close SseEventSink", e);
        }
    }

    @GET
    @Path(value="xml")
    @Produces(value={"text/event-stream"})
    public void sendXML(@Context SseEventSink sink, @Context Sse sse) {
        try (SseEventSink s = sink;){
            JaxbKeyValueBean bean = new JaxbKeyValueBean();
            bean.set("key", "some_ServiceUnavailableEndpoint_message");
            s.send(sse.newEventBuilder().data((Object)bean).mediaType(mediaType).build());
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Failed to close SseEventSink", e);
        }
    }

    @GET
    @Path(value="map")
    @Produces(value={"text/event-stream"})
    public void sendMap(@Context SseEventSink sink, @Context Sse sse) {
        try (SseEventSink s = sink;){
            SinglevaluedMap<String, String> map = new SinglevaluedMap<String, String>();
            map.add("key", "some_ServiceUnavailableEndpoint_message");
            s.send(sse.newEventBuilder().data(map).mediaType(mediaType).build());
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Failed to close SseEventSink", e);
        }
    }
}

