/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.core.response;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.common.provider.PrintingErrorHandler;
import ee.jakarta.tck.ws.rs.common.provider.StringBean;
import ee.jakarta.tck.ws.rs.common.provider.StringBeanEntityProvider;
import ee.jakarta.tck.ws.rs.common.provider.StringBeanHeaderDelegate;
import ee.jakarta.tck.ws.rs.common.provider.StringBeanRuntimeDelegate;
import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import ee.jakarta.tck.ws.rs.ee.rs.core.response.AnnotatedClass;
import ee.jakarta.tck.ws.rs.ee.rs.core.response.CorruptedInputStream;
import ee.jakarta.tck.ws.rs.ee.rs.core.response.DateReaderWriter;
import ee.jakarta.tck.ws.rs.ee.rs.core.response.ResponseTest;
import ee.jakarta.tck.ws.rs.ee.rs.core.response.TSAppConfig;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    private static final long serialVersionUID = 4182256439207983256L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_core_response_web/resource");
        this.setPrintEntity(true);
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/core/response/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_core_response_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, JaxrsUtil.class, ResponseTest.class, CorruptedInputStream.class, StringBean.class, StringBeanHeaderDelegate.class, StringBeanEntityProvider.class, StringBeanRuntimeDelegate.class, PrintingErrorHandler.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void statusTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (status == Response.Status.RESET_CONTENT) continue;
            this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(status));
            this.invokeGet("status?status=" + JAXRSClientIT.getStatusCode(status));
        }
    }

    @Test
    public void bufferEntityBuffersDataTest() throws JAXRSCommonClient.Fault {
        Response response = this.invokeGet("entity");
        boolean buffer = response.bufferEntity();
        Assertions.assertTrue((boolean)buffer, (String)"#bufferEntity() did not buffer opened stream");
        buffer = response.bufferEntity();
        Assertions.assertTrue((boolean)buffer, (String)"#bufferEntity() is not idempotent");
        String read = (String)response.readEntity(String.class);
        Assertions.assertTrue((boolean)read.equals("ENtiTy"), (String)("Read entity" + read + "instead ofENtiTy"));
        read = (String)response.readEntity(String.class);
        Assertions.assertTrue((boolean)read.equals("ENtiTy"), (String)("Read entity" + read + "instead ofENtiTy"));
        JAXRSClientIT.logMsg("#bufferEntity did buffer opened stream as expected");
    }

    @Test
    public void bufferEntityThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        this.setCorruptedStream();
        Response response = this.invokeGet("corrupted");
        this.catchCorruptedStreamExceptionOnBufferEntity(response);
        JAXRSClientIT.logMsg("ProcessingException has been thrown as expected");
    }

    @Test
    public void bufferEntityThrowsIllegalStateExceptionTest() throws JAXRSCommonClient.Fault {
        Response response = this.invokeGet("entity");
        response.close();
        try {
            response.bufferEntity();
            JAXRSClientIT.fault("buffer entity did not throw IllegalStateException when closed");
        }
        catch (IllegalStateException e) {
            JAXRSClientIT.logMsg("#bufferEntity throws IllegalStateException as expected");
        }
    }

    @Test
    public void closeTest() throws JAXRSCommonClient.Fault {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target("http://" + this._hostname + ":" + this._port + this.getContextRoot()).path("entity");
        Response response = target.request(new MediaType[]{MediaType.TEXT_PLAIN_TYPE}).buildGet().invoke();
        response.close();
        response.close();
        try {
            String entity = (String)response.readEntity(String.class);
            Assertions.assertTrue((boolean)false, (String)("IllegalStateException has not been thrown when#close() and #readEntity() but entity" + entity + "has been read"));
        }
        catch (IllegalStateException e) {
            JAXRSClientIT.logMsg("#close() closed the stream, and consecutive reading threw IllegalStateException as expected");
        }
    }

    @Test
    public void closeThrowsExceptionWhenErrorTest() throws JAXRSCommonClient.Fault {
        this.setCorruptedStream();
        Response response = this.invokeGet("corrupted");
        try {
            response.close();
            Assertions.assertTrue((boolean)false, (String)"ProcessingException has not been thrown whenCorruptedInputStream#close()");
        }
        catch (ProcessingException e) {
            JAXRSClientIT.assertNotNull(e.getCause(), new Object[]{"unknown exception thrown", e});
            JAXRSClientIT.assertEquals(e.getCause().getMessage(), "CorruptedInputStream tck test IOException", new Object[]{"unknown exception thrown", e});
            JAXRSClientIT.logMsg("#close() threw ProcessingException as expected");
        }
    }

    @Test
    public void getAllowedMethodsTest() throws JAXRSCommonClient.Fault {
        String allowed = JAXRSCommonClient.Request.POST.name() + " " + JAXRSCommonClient.Request.TRACE.name();
        Response response = this.invokePost("allowedmethods", allowed);
        Set set = response.getAllowedMethods();
        String methods = JaxrsUtil.iterableToString(";", set);
        JAXRSClientIT.assertContainsIgnoreCase(methods, JAXRSCommonClient.Request.POST.name(), new Object[]{JAXRSCommonClient.Request.POST.name(), "method has not been found"});
        JAXRSClientIT.assertContainsIgnoreCase(methods, JAXRSCommonClient.Request.TRACE.name(), new Object[]{JAXRSCommonClient.Request.TRACE.name(), "method has not been found"});
        Assertions.assertTrue((methods.length() < JAXRSCommonClient.Request.TRACE.name().length() + JAXRSCommonClient.Request.POST.name().length() + 3 ? 1 : 0) != 0, (String)("Request contains some additional methods then expected" + methods));
        JAXRSClientIT.logMsg("#getAllowedMethods returned expected methods", methods);
    }

    @Test
    public void getCookiesTest() throws JAXRSCommonClient.Fault {
        Response response = this.invokeGet("cookies");
        Map map = response.getCookies();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            String value = ((NewCookie)entry.getValue()).getValue();
            if (key.equals("c1")) {
                JAXRSClientIT.assertEquals(value, "v1", value, "does not match expected v1");
                continue;
            }
            if (key.equals("c2")) {
                JAXRSClientIT.assertEquals(value, "v2", value, "does not match expected v2");
                continue;
            }
            JAXRSClientIT.fault("Got unknown cookie", entry.getKey());
        }
        JAXRSClientIT.logMsg("#getCookies returned expected cookies");
    }

    @Test
    public void getCookiesIsImmutableTest() throws JAXRSCommonClient.Fault {
        Map map;
        NewCookie cookie3 = new NewCookie("c3", "v3");
        Response response = this.invokeGet("cookies");
        try {
            map = response.getCookies();
            map.put("c3", cookie3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        map = response.getCookies();
        Assertions.assertFalse((boolean)map.containsKey("c3"), (String)("getCookies is not read-only returned" + map.get("c3")));
        JAXRSClientIT.logMsg("#getCookies is read-only as expected");
    }

    @Test
    public void getDateTest() throws JAXRSCommonClient.Fault {
        long date = this.getCurrentTimeMillis();
        Response response = this.invokePost("date", String.valueOf(date));
        long responseDate = response.getDate().getTime();
        Assertions.assertTrue((Math.abs(responseDate - date) < 600000L ? 1 : 0) != 0, (String)"#getDate() returned time that differes by more than 10 minutes");
        JAXRSClientIT.logMsg("#getDate matches the Date HTTP header");
    }

    @Test
    public void getEntityThrowsIllegalStateExceptionTestWhenClosed() throws JAXRSCommonClient.Fault {
        Response response = this.invokeGet("entity");
        response.close();
        try {
            Object entity = response.getEntity();
            JAXRSClientIT.fault("No exception has been thrown, entity=", entity);
        }
        catch (IllegalStateException e) {
            JAXRSClientIT.logMsg("#getEntity throws IllegalStateException as expected", e);
        }
    }

    @Test
    public void getEntityThrowsIllegalStateExceptionWhenConsumedTest() throws JAXRSCommonClient.Fault {
        Response response = this.invokeGet("entity");
        response.readEntity(String.class);
        try {
            Object entity = response.getEntity();
            JAXRSClientIT.fault("No exception has been thrown entity=", entity);
        }
        catch (IllegalStateException e) {
            JAXRSClientIT.logMsg("#getEntity throws IllegalStateException as expected", e);
        }
    }

    @Test
    public void getEntityTagTest() throws JAXRSCommonClient.Fault {
        String tag = "ABCDEF0123456789";
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.NOT_MODIFIED));
        Response response = this.invokePost("entitytag", tag);
        EntityTag responseTag = response.getEntityTag();
        JAXRSClientIT.assertEquals(tag, responseTag.getValue(), "response#getEntityTag()", responseTag.getValue(), "is unequal to expected EntityTag", tag);
        JAXRSClientIT.logMsg("#getEntityTag is", responseTag, "as expected");
    }

    @Test
    public void getEntityTagNotPresentTest() throws JAXRSCommonClient.Fault {
        ResponseHeaderValue value = new ResponseHeaderValue();
        this.addProvider(new HeaderNotPresent<EntityTag>(value){

            @Override
            protected void setHeader(ClientResponseContext responseContext, ResponseHeaderValue<EntityTag> header) {
                header.value = responseContext.getEntityTag();
            }
        });
        Response response = this.invokePost("entitytag", null);
        EntityTag responseTag = response.getEntityTag();
        this.assertHeaderNull(responseTag, value, "getEntityTag");
    }

    @Test
    public void getHeadersTest() throws JAXRSCommonClient.Fault {
        Response response = this.invokePost("headers", "notnull");
        JAXRSClientIT.logMsg("Found following objects:");
        JAXRSClientIT.logMsg(JaxrsCommonClient.getMetadata((MultivaluedMap<String, Object>)response.getHeaders()));
        MultivaluedMap headers = response.getHeaders();
        String header = null;
        header = headers.getFirst((Object)"Cache-Control").toString();
        JAXRSClientIT.assertContainsIgnoreCase(header, "no-transform", new Object[]{"Cache-Control:no-transform has not been found"});
        header = headers.getFirst((Object)"Set-Cookie").toString();
        JAXRSClientIT.assertContainsIgnoreCase(header, "cookie=eikooc", new Object[]{"Set-Cookie:cookie=eikooc has not been found"});
        header = headers.getFirst((Object)"Content-Encoding").toString();
        JAXRSClientIT.assertContainsIgnoreCase(header, "gzip", new Object[]{"Content-Encoding:gzip has not been found"});
        header = headers.getFirst((Object)"Expires").toString();
        JAXRSClientIT.assertNotNull(header, "Expires has not been found");
        header = headers.getFirst((Object)"Content-Language").toString();
        JAXRSClientIT.assertContainsIgnoreCase(this.langToString(header), this.langToString(Locale.CANADA_FRENCH), new Object[]{"Content-Language:", this.langToString(Locale.CANADA_FRENCH), "has not been found"});
        Object noHeader = headers.getFirst((Object)"unknown");
        JAXRSClientIT.assertNull(noHeader, "Unknown header has been found", header);
    }

    @Test
    public void getHeadersUsingHeaderDelegateTest() throws JAXRSCommonClient.Fault {
        this.invokeGet("setstringbeanruntime");
        Response response = this.invokePost("headerstring", "notnull");
        String[] metadata = JaxrsCommonClient.getMetadata((MultivaluedMap<String, Object>)response.getHeaders());
        JAXRSClientIT.logMsg("Received:");
        JAXRSClientIT.logMsg(metadata);
        String headers = JaxrsUtil.iterableToString(";", metadata);
        for (int i = 1; i != 4; ++i) {
            String header = "s" + i + ":s" + i;
            JAXRSClientIT.assertContainsIgnoreCase(headers, header, new Object[]{"Expected header", header, "was not found in received headers", headers});
        }
        JAXRSClientIT.logMsg("Received expected headers", headers);
        this.invokeGet("setoriginalruntime");
    }

    @Test
    public void getHeadersIsMutableTest() throws JAXRSCommonClient.Fault {
        String header = "header";
        Response response = this.invokePost("headers", null);
        MultivaluedMap headers = response.getHeaders();
        Object value = headers.getFirst((Object)header);
        JAXRSClientIT.assertNull(value, "Unexpected header", header, ":", value);
        headers.add((Object)header, (Object)header);
        headers = response.getHeaders();
        value = headers.getFirst((Object)header);
        JAXRSClientIT.assertContainsIgnoreCase(value, header, "Unexpected header value", header, ":", value);
        JAXRSClientIT.logMsg("getHeaders is mutable");
    }

    @Test
    public void getHeaderStringTest() throws JAXRSCommonClient.Fault {
        Response response = this.invokePost("headers", "headerstring");
        JAXRSClientIT.logMsg("Found following objects:");
        JAXRSClientIT.logMsg(JaxrsCommonClient.getMetadata((MultivaluedMap<String, Object>)response.getHeaders()));
        JAXRSClientIT.assertContainsIgnoreCase(response.getHeaderString("Cache-Control"), "no-transform", new Object[]{"Cache-Control:no-transform has not been found"});
        JAXRSClientIT.assertContainsIgnoreCase(response.getHeaderString("Set-Cookie"), "cookie=eikooc", new Object[]{"Set-Cookie:cookie=eikooc has not been found"});
        JAXRSClientIT.assertContainsIgnoreCase(response.getHeaderString("Content-Encoding"), "gzip", new Object[]{"Content-Encoding:gzip has not been found"});
        JAXRSClientIT.assertNotNull(response.getHeaderString("Expires"), "Expires has not been found");
        JAXRSClientIT.assertContainsIgnoreCase(this.langToString(response.getHeaderString("Content-Language")), this.langToString(Locale.CANADA_FRENCH), new Object[]{"Content-Language:", this.langToString(Locale.CANADA_FRENCH), "has not been found"});
        JAXRSClientIT.assertNull(response.getHeaderString("unknown"), "Unknown header has been found", response.getHeaderString("unknown"));
    }

    @Test
    public void getHeaderStringUsingHeaderDelegateTest() throws JAXRSCommonClient.Fault {
        this.invokeGet("setstringbeanruntime");
        Response response = this.invokePost("headerstring", "delegate");
        String header = response.getHeaderString("s3");
        JAXRSClientIT.assertContainsIgnoreCase(header, "s3", new Object[]{"Header", "s3", "has unexpected value", header});
        JAXRSClientIT.logMsg("HeaderDelegate is used for header as expected");
        this.invokeGet("setoriginalruntime");
    }

    @Test
    public void getHeaderStringUsingToStringTest() throws JAXRSCommonClient.Fault {
        Response response = this.invokePost("headerstring", "toString");
        String header = response.getHeaderString("s1");
        JAXRSClientIT.assertContainsIgnoreCase(header, "s1", new Object[]{"Header s1 has unexpected value", header});
        header = response.getHeaderString("s2");
        JAXRSClientIT.assertContainsIgnoreCase(header, "s2", new Object[]{"Header s2 has unexpected value", header});
        JAXRSClientIT.logMsg("toString method is used as expected");
    }

    @Test
    public void getLanguageTest() throws JAXRSCommonClient.Fault {
        Response response = this.invokePost("language", Locale.CANADA_FRENCH.getCountry());
        Locale locale = response.getLanguage();
        Assertions.assertTrue((boolean)Locale.CANADA_FRENCH.equals(locale), (String)("Locale" + Locale.CANADA_FRENCH + "does NOT match response#getLocale()" + locale));
        JAXRSClientIT.logMsg("#getLocale matches the Content-Language HTTP header");
    }

    @Test
    public void getLanguageNotPresentTest() throws JAXRSCommonClient.Fault {
        ResponseHeaderValue value = new ResponseHeaderValue();
        this.addProvider(new HeaderNotPresent<Locale>(value){

            @Override
            protected void setHeader(ClientResponseContext responseContext, ResponseHeaderValue<Locale> header) {
                header.value = responseContext.getLanguage();
            }
        });
        Response response = this.invokePost("language", null);
        Locale locale = response.getLanguage();
        this.assertHeaderNull(locale, value, "getLanguage");
    }

    @Test
    public void getLastModifiedTest() throws JAXRSCommonClient.Fault {
        long time = this.getCurrentTimeMillis();
        Response response = this.invokePost("lastmodified", String.valueOf(time));
        long responseDate = response.getLastModified().getTime();
        JAXRSClientIT.assertEqualsLong(time, responseDate, "Last Modified date", time, "does NOT match response#getLastModified()", responseDate);
        JAXRSClientIT.logMsg("#getLastModified matches the Last-Modified HTTP header");
    }

    @Test
    public void getLastModifiedNotPresentTest() throws JAXRSCommonClient.Fault {
        ResponseHeaderValue containerValue = new ResponseHeaderValue();
        this.addProvider(new HeaderNotPresent<Date>(containerValue){

            @Override
            protected void setHeader(ClientResponseContext responseContext, ResponseHeaderValue<Date> header) {
                header.value = responseContext.getLastModified();
            }
        });
        Response response = this.invokePost("lastmodified", null);
        Date responseDate = response.getLastModified();
        this.assertHeaderNull(responseDate, containerValue, "getLastModified");
    }

    @Test
    public void getLengthTest() throws JAXRSCommonClient.Fault {
        Response response = this.invokePost("length", "1234567890");
        int len = response.getLength();
        Assertions.assertTrue((len > 9 ? 1 : 0) != 0, (String)("Expected Content-Length > 9does NOT match response#getLength()" + len));
        JAXRSClientIT.logMsg("#getLength matches expected Content-Length", len);
    }

    @Test
    public void getLengthNotPresentTest() throws JAXRSCommonClient.Fault {
        Response response = this.invokePost("length", null);
        int len = response.getLength();
        String headerLen = response.getHeaderString("Content-Length");
        if (headerLen == null) {
            JAXRSClientIT.assertEqualsInt(len, -1, "Expected Content-Length = -1", "does NOT match response#getLength()", len);
        } else {
            JAXRSClientIT.assertEqualsInt(len, Integer.parseInt(headerLen), "Expected Content-Length =", headerLen, "does NOT match response#getLength()=", len);
        }
        JAXRSClientIT.logMsg("#getLength matches expected Content-Length", len);
    }

    @Test
    public void getLinkTest() throws JAXRSCommonClient.Fault {
        String rel = "getLinkTest";
        Response response = this.invokePost("link", rel);
        Link responseLink = response.getLink(rel);
        JAXRSClientIT.assertNotNull(responseLink, "#getLink is null");
        JAXRSClientIT.assertContains(rel, responseLink.getRel(), new Object[]{"#getLink() returned unexpected Link", responseLink});
        JAXRSClientIT.logMsg("#getLink matches expected Link");
    }

    @Test
    public void getLinkNotPresentTest() throws JAXRSCommonClient.Fault {
        ResponseHeaderValue containerValue = new ResponseHeaderValue();
        this.addProvider(new HeaderNotPresent<Link>(containerValue){

            @Override
            protected void setHeader(ClientResponseContext responseContext, ResponseHeaderValue<Link> header) {
                header.value = responseContext.getLink("getLinkTest");
            }
        });
        Response response = this.invokePost("link", null);
        Link responseLink = response.getLink("getLinkTest");
        this.assertHeaderNull(responseLink, containerValue, "getLink");
    }

    @Test
    public void getLinkBuilderForTheRelationTest() throws JAXRSCommonClient.Fault {
        String rel = "anyrelation";
        Response response = this.invokePost("linkbuilder", rel);
        Link responseLink = response.getLink(rel);
        JAXRSClientIT.assertNotNull(responseLink, "#getLinkBuilder('relation') returned null");
        JAXRSClientIT.logMsg("#getLinkBuilder creates correct Link for given relation");
    }

    @Test
    public void getLinkBuilderForTheNotPresentRelationTest() throws JAXRSCommonClient.Fault {
        Response response = this.invokeGet("entity");
        Link.Builder builder = response.getLinkBuilder("anyrelation");
        JAXRSClientIT.assertNull(builder, "#getLinkBuilder('relation') returned unexpected builder", builder);
        JAXRSClientIT.logMsg("#getLinkBuilder returned null as expected");
    }

    @Test
    public void getLinksTest() throws JAXRSCommonClient.Fault {
        Response response = this.invokeGet("links");
        Set responseLinks = response.getLinks();
        JAXRSClientIT.assertEqualsInt(responseLinks.size(), 2, "#getLinks() returned set of unexpected size", responseLinks.size());
        JAXRSClientIT.logMsg("#getLinks contains expected links");
    }

    @Test
    public void getLinksIsNotNullTest() throws JAXRSCommonClient.Fault {
        Response response = this.invokeGet("entity");
        Set responseLinks = response.getLinks();
        Assertions.assertTrue((responseLinks != null ? 1 : 0) != 0, (String)"#getLinks() returned null!");
        Assertions.assertTrue((responseLinks.size() == 0 ? 1 : 0) != 0, (String)"#getLinks() returned non-empty map!");
        JAXRSClientIT.logMsg("#getLinks contains no links as expected");
    }

    @Test
    public void getLocationTest() throws JAXRSCommonClient.Fault {
        String path = "path";
        URI serverUri = ResponseTest.createUri(path);
        Response response = this.invokePost("location", path);
        URI responseLocation = response.getLocation();
        JAXRSClientIT.assertEquals(responseLocation, serverUri, "#getLocation()", responseLocation, "differs from expected", serverUri);
        JAXRSClientIT.logMsg("#getLocation contains expected location");
    }

    @Test
    public void getLocationNotPresentTest() throws JAXRSCommonClient.Fault {
        ResponseHeaderValue containerValue = new ResponseHeaderValue();
        this.addProvider(new HeaderNotPresent<URI>(containerValue){

            @Override
            protected void setHeader(ClientResponseContext responseContext, ResponseHeaderValue<URI> header) {
                header.value = responseContext.getLocation();
            }
        });
        Response response = this.invokeGet("entity");
        URI responseLocation = response.getLocation();
        this.assertHeaderNull(responseLocation, containerValue, "getLocation");
    }

    @Test
    public void getMediaTypeTest() throws JAXRSCommonClient.Fault {
        MediaType mediaType = MediaType.APPLICATION_ATOM_XML_TYPE;
        Response response = this.invokePost("mediatype", mediaType.toString());
        MediaType responseMedia = response.getMediaType();
        JAXRSClientIT.assertEquals(mediaType, responseMedia, "#getMediaType()", responseMedia, "differs from expected", "application/atom+xml");
        JAXRSClientIT.logMsg("#getMediaType returned expected MediaType");
    }

    @Test
    public void getStatusInfoTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(status));
            Response response = this.invokePost("statusinfo", status.name());
            Response.StatusType info = response.getStatusInfo();
            JAXRSClientIT.assertEqualsInt(info.getStatusCode(), status.getStatusCode(), "#getStatusInfo returned unexpected value", info);
        }
        JAXRSClientIT.logMsg("#getStatusInfo returned expected StatusTypes");
    }

    @Test
    public void getStringHeadersUsingToStringTest() throws JAXRSCommonClient.Fault {
        Response response = this.invokePost("headerstring", "stringheaders");
        MultivaluedMap headers = response.getStringHeaders();
        String header = (String)headers.getFirst((Object)"s1");
        JAXRSClientIT.assertContainsIgnoreCase(header, "s1", new Object[]{"Header", "s1", "has unexpected value", header});
        header = (String)headers.getFirst((Object)"s2");
        JAXRSClientIT.assertContainsIgnoreCase(header, "s2", new Object[]{"Header", "s2", "has unexpected value", header});
        JAXRSClientIT.logMsg("#getStringHeaders contains expected values", JaxrsUtil.iterableToString(",", headers.entrySet()));
    }

    @Test
    public void getStringHeadersUsingHeaderDelegateTest() throws JAXRSCommonClient.Fault {
        this.invokeGet("setstringbeanruntime");
        Response response = this.invokePost("headerstring", "stringheaders");
        MultivaluedMap headers = response.getStringHeaders();
        String header = (String)headers.getFirst((Object)"s3");
        JAXRSClientIT.assertContainsIgnoreCase("s3", header, new Object[]{"Header", "s3", "has unexpected value", header});
        JAXRSClientIT.logMsg("#getStringHeaders contains expected values", JaxrsUtil.iterableToString(",", headers.entrySet()));
        this.invokeGet("setoriginalruntime");
    }

    @Test
    public void hasEntityWhenEntityTest() throws JAXRSCommonClient.Fault {
        Response response = this.invokeGet("entity");
        Assertions.assertTrue((boolean)response.hasEntity(), (String)"#hasEntity did not found the entity");
        JAXRSClientIT.logMsg("#hasEntity found the entity as expected");
    }

    @Test
    public void hasEntityWhenNoEntityTest() throws JAXRSCommonClient.Fault {
        Response response = this.invokePost("headerstring", null);
        Assertions.assertFalse((boolean)response.hasEntity(), (String)"#hasEntity did found the entity");
        JAXRSClientIT.logMsg("#hasEntity has not found any entity as expected");
    }

    @Test
    public void hasEntityThrowsIllegalStateExceptionTest() throws JAXRSCommonClient.Fault {
        Response response = this.invokeGet("entity");
        response.close();
        try {
            response.hasEntity();
            JAXRSClientIT.fault("No exception has been thrown");
        }
        catch (IllegalStateException e) {
            JAXRSClientIT.logMsg("IllegalStateException has been thrown as expected");
        }
    }

    @Test
    public void hasLinkWhenLinkTest() throws JAXRSCommonClient.Fault {
        Response response = this.invokePost("link", "path");
        Assertions.assertTrue((boolean)response.hasLink("path"), (String)"#hasLink did not found a Link");
        JAXRSClientIT.logMsg("#hasEntity found the Link as expected");
    }

    @Test
    public void hasLinkWhenNoLinkTest() throws JAXRSCommonClient.Fault {
        Response response = this.invokeGet("entity");
        Assertions.assertFalse((boolean)response.hasLink("rel"), (String)"#has Link did found some Link");
        JAXRSClientIT.logMsg("#hasLink has not found any Link as expected");
    }

    @Test
    public void readEntityClassTest() throws JAXRSCommonClient.Fault {
        Response response = this.invokeGet("entity");
        response.bufferEntity();
        Reader reader = (Reader)response.readEntity(Reader.class);
        String line = this.readLine(reader);
        Assertions.assertTrue((boolean)"ENtiTy".equals(line), (String)("#readEntity(Reader)={" + line + "} differs from expectedENtiTy"));
        byte[] buffer = new byte[]{};
        buffer = (byte[])response.readEntity(buffer.getClass());
        line = new String(buffer);
        Assertions.assertTrue((boolean)"ENtiTy".equals(line), (String)("#readEntity(byte[].class)={" + line + "} differs from expectedENtiTy"));
        JAXRSClientIT.logMsg("Got expected", line);
    }

    @Test
    public void readEntityClassIsNullWhenNoEntityTest() throws JAXRSCommonClient.Fault {
        Response response = this.invokeGet("status?status=200");
        String entity = (String)response.readEntity(String.class);
        Assertions.assertTrue((entity == null || "".equals(entity) ? 1 : 0) != 0, (String)("entity is not null or zero length" + entity));
        JAXRSClientIT.logMsg("Null or zero length entity returned when no entity as expected");
    }

    @Test
    public void readEntityClassCloseIsCalledTest() throws JAXRSCommonClient.Fault {
        AtomicInteger ai = this.setCorruptedStream();
        final Response response = this.invokeGet("corrupted");
        this.catchCorruptedStreamException(new Runnable(){

            @Override
            public void run() {
                response.readEntity(String.class);
            }
        });
        JAXRSClientIT.assertEquals(ai.get(), 999, "Close has not been called");
        JAXRSClientIT.logMsg("Close() has been called on an entity stream as expected");
    }

    @Test
    public void readEntityClassCloseIsNotCalledOnInputStreamTest() throws JAXRSCommonClient.Fault {
        AtomicInteger ai = this.setCorruptedStream();
        Response response = this.invokeGet("corrupted");
        try {
            response.readEntity(InputStream.class);
            JAXRSClientIT.logMsg("Close() has not been called on entity stream as expected");
        }
        catch (Exception e) {
            throw new JAXRSCommonClient.Fault("Close was called", e);
        }
        Assertions.assertTrue((ai.get() == 0 ? 1 : 0) != 0, (String)"Close was called");
    }

    @Test
    public void readEntityClassThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        Response response = this.invokeGet("entity");
        try {
            response.readEntity(Void.class);
            throw new JAXRSCommonClient.Fault("No exception has been thrown when reader for entity class is not known");
        }
        catch (ProcessingException e) {
            JAXRSClientIT.logMsg("ProcessingException has been thrown as expected");
            return;
        }
    }

    @Test
    public void readEntityClassThrowsIllegalStateExceptionTest() throws JAXRSCommonClient.Fault {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target("http://" + this._hostname + ":" + this._port + this.getContextRoot()).path("entity");
        Response response = target.request(new MediaType[]{MediaType.TEXT_PLAIN_TYPE}).buildGet().invoke();
        String entity = (String)response.readEntity(String.class);
        Assertions.assertTrue((boolean)"ENtiTy".equals(entity), (String)("#readEntity(String.class)={" + entity + "} differs from expectedENtiTy"));
        try {
            response.readEntity(Reader.class);
            throw new JAXRSCommonClient.Fault("No exception has been thrown when reader for entity is not buffered");
        }
        catch (IllegalStateException e) {
            JAXRSClientIT.logMsg("IllegalStateException has been thrown as expected");
            return;
        }
    }

    @Test
    public void readEntityGenericTypeTest() throws JAXRSCommonClient.Fault {
        Response response = this.invokeGet("entity");
        response.bufferEntity();
        Reader reader = (Reader)response.readEntity(this.generic(Reader.class));
        String line = this.readLine(reader);
        Assertions.assertTrue((boolean)"ENtiTy".equals(line), (String)("#readEntity(GenericType<Reader>)={" + line + "} differs from expectedENtiTy"));
        byte[] buffer = new byte[]{};
        buffer = (byte[])response.readEntity(this.generic(buffer.getClass()));
        Assertions.assertTrue((buffer != null ? 1 : 0) != 0, (String)"response.readEntity(GenericType<byte[]>) is null");
        line = new String(buffer);
        Assertions.assertTrue((boolean)"ENtiTy".equals(line), (String)("#readEntity(GenericType<byte[]>)={" + line + "} differs from expectedENtiTy"));
        JAXRSClientIT.logMsg("Got expected", line);
    }

    @Test
    public void readEntityGenericIsNullWhenNoEntityTest() throws JAXRSCommonClient.Fault {
        String request = this.buildRequest(JAXRSCommonClient.Request.GET, "status?status=200");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, request);
        this.invoke();
        Response response = this.getResponse();
        String entity = (String)response.readEntity(this.generic(String.class));
        Assertions.assertTrue((entity == null || "".equals(entity) ? 1 : 0) != 0, (String)("entity is not null or zero length" + entity));
        JAXRSClientIT.logMsg("Null or zero length entity returned when no entity as expected");
    }

    @Test
    public void readEntityGenericCloseIsCalledTest() throws JAXRSCommonClient.Fault {
        AtomicInteger ai = this.setCorruptedStream();
        final Response response = this.invokeGet("corrupted");
        this.catchCorruptedStreamException(new Runnable(){

            @Override
            public void run() {
                response.readEntity(JAXRSClientIT.this.generic(String.class));
            }
        });
        Assertions.assertTrue((ai.get() == 999 ? 1 : 0) != 0, (String)"Close has not been called");
        JAXRSClientIT.logMsg("Close() has been called on an entity stream as expected");
    }

    @Test
    public void readEntityGenericTypeCloseIsNotCalledOnInputStreamTest() throws JAXRSCommonClient.Fault {
        AtomicInteger ai = this.setCorruptedStream();
        Response response = this.invokeGet("corrupted");
        try {
            response.readEntity(this.generic(InputStream.class));
            JAXRSClientIT.logMsg("Close() has not been called on entity stream as expected");
        }
        catch (Exception e) {
            throw new JAXRSCommonClient.Fault("Close was called", e);
        }
        Assertions.assertTrue((ai.get() == 0 ? 1 : 0) != 0, (String)"Close was called");
    }

    @Test
    public void readEntityGenericTypeThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        Response response = this.invokeGet("entity");
        try {
            response.readEntity(this.generic(Void.class));
            throw new JAXRSCommonClient.Fault("No exception has been thrown when reader for entity class is not known");
        }
        catch (ProcessingException e) {
            JAXRSClientIT.logMsg("ProcessingException has been thrown as expected");
            return;
        }
    }

    @Test
    public void readEntityGenericTypeThrowsIllegalStateExceptionTest() throws JAXRSCommonClient.Fault {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target("http://" + this._hostname + ":" + this._port + this.getContextRoot()).path("entity");
        Response response = target.request(new MediaType[]{MediaType.TEXT_PLAIN_TYPE}).buildGet().invoke();
        String entity = (String)response.readEntity(this.generic(String.class));
        Assertions.assertTrue((boolean)"ENtiTy".equals(entity), (String)("#readEntity(GenericType<byte[]>)={" + entity + "} differs from expectedENtiTy"));
        try {
            response.readEntity(this.generic(Reader.class));
            throw new JAXRSCommonClient.Fault("No exception has been thrown when reader for entity is not buffered");
        }
        catch (IllegalStateException e) {
            JAXRSClientIT.logMsg("IllegalStateException has been thrown as expected");
            return;
        }
    }

    @Test
    public void readEntityClassAnnotationTest() throws JAXRSCommonClient.Fault {
        Date date = Calendar.getInstance().getTime();
        String sDate = String.valueOf(date.getTime());
        Annotation[] annotations = AnnotatedClass.class.getAnnotations();
        int expected = 12;
        AtomicInteger ai = new AtomicInteger();
        DateReaderWriter drw = new DateReaderWriter(ai);
        this.addProvider(drw);
        Response response = this.invokeGet("date?date=" + sDate);
        response.bufferEntity();
        Date entity = (Date)response.readEntity(Date.class, annotations);
        Assertions.assertTrue((boolean)date.equals(entity), (String)("#readEntity(Date, annotations)={" + entity + "} differs from expected" + date));
        Assertions.assertTrue((ai.get() == expected ? 1 : 0) != 0, (String)(ai.get() + "differes from expected" + expected + "which suggest a problem with annotation passing"));
        String responseDate = (String)response.readEntity(String.class, annotations);
        Assertions.assertTrue((boolean)sDate.equals(responseDate), (String)("#readEntity(String.class, annotations)={" + responseDate + "} differs from expected" + sDate));
        Assertions.assertTrue((ai.get() == expected ? 1 : 0) != 0, (String)(ai.get() + "differes from expected" + expected + "which suggest a problem with annotation passing"));
        JAXRSClientIT.logMsg("Got expected date", date);
    }

    @Test
    public void readEntityClassAnnotationIsNullWhenNoEntityTest() throws JAXRSCommonClient.Fault {
        Annotation[] annotations = AnnotatedClass.class.getAnnotations();
        Response response = this.invokeGet("status?status=200");
        String entity = (String)response.readEntity(String.class, annotations);
        Assertions.assertTrue((entity == null || "".equals(entity) ? 1 : 0) != 0, (String)("entity is not null or zero length" + entity));
        JAXRSClientIT.logMsg("Null or zero length entity returned when no entity as expected");
    }

    @Test
    public void readEntityClassAnnotationCloseIsCalledTest() throws JAXRSCommonClient.Fault {
        final Annotation[] annotations = AnnotatedClass.class.getAnnotations();
        AtomicInteger ai = this.setCorruptedStream();
        final Response response = this.invokeGet("corrupted");
        this.catchCorruptedStreamException(new Runnable(){

            @Override
            public void run() {
                response.readEntity(String.class, annotations);
            }
        });
        JAXRSClientIT.assertEqualsInt(ai.get(), 999, "Close has not been called");
        JAXRSClientIT.logMsg("Close() has been called on an entity stream as expected");
    }

    @Test
    public void readEntityClassAnnotationCloseIsNotCalledOnInputStreamTest() throws JAXRSCommonClient.Fault {
        Annotation[] annotations = AnnotatedClass.class.getAnnotations();
        AtomicInteger ai = this.setCorruptedStream();
        Response response = this.invokeGet("corrupted");
        try {
            response.readEntity(InputStream.class, annotations);
            JAXRSClientIT.logMsg("Close() has not been called on entity stream as expected");
        }
        catch (ProcessingException e) {
            throw new JAXRSCommonClient.Fault("Close was called", e);
        }
        Assertions.assertTrue((ai.get() == 0 ? 1 : 0) != 0, (String)"Close was called");
    }

    @Test
    public void readEntityClassAnnotationThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        Annotation[] annotations = AnnotatedClass.class.getAnnotations();
        Response response = this.invokeGet("entity");
        try {
            response.readEntity(Void.class, annotations);
            throw new JAXRSCommonClient.Fault("No exception has been thrown when reader for entity class is not known");
        }
        catch (ProcessingException e) {
            JAXRSClientIT.logMsg("ProcessingException has been thrown as expected");
            return;
        }
    }

    @Test
    public void readEntityClassAnnotationThrowsIllegalStateExceptionTest() throws JAXRSCommonClient.Fault {
        Annotation[] annotations = AnnotatedClass.class.getAnnotations();
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target("http://" + this._hostname + ":" + this._port + this.getContextRoot()).path("entity");
        Response response = target.request(new MediaType[]{MediaType.TEXT_PLAIN_TYPE}).buildGet().invoke();
        String entity = (String)response.readEntity(String.class, annotations);
        Assertions.assertTrue((boolean)"ENtiTy".equals(entity), (String)("#readEntity(String.class, annotations)={" + entity + "} differs from expectedENtiTy"));
        try {
            response.readEntity(Reader.class, annotations);
            throw new JAXRSCommonClient.Fault("No exception has been thrown when reader for entity is not buffered");
        }
        catch (IllegalStateException e) {
            JAXRSClientIT.logMsg("IllegalStateException has been thrown as expected");
            return;
        }
    }

    @Test
    public void readEntityGenericTypeAnnotationTest() throws JAXRSCommonClient.Fault {
        Date date = Calendar.getInstance().getTime();
        String sDate = String.valueOf(date.getTime());
        Annotation[] annotations = AnnotatedClass.class.getAnnotations();
        int expected = 12;
        AtomicInteger ai = new AtomicInteger();
        DateReaderWriter drw = new DateReaderWriter(ai);
        this.addProvider(drw);
        Response response = this.invokeGet("date?date=" + sDate);
        response.bufferEntity();
        Date entity = (Date)response.readEntity(this.generic(Date.class), annotations);
        Assertions.assertTrue((boolean)date.equals(entity), (String)("#readEntity(Date, annotations)={" + entity + "} differs from expected" + date));
        Assertions.assertTrue((ai.get() == expected ? 1 : 0) != 0, (String)(ai.get() + "differes from expected" + expected + "which suggest a problem with annotation passing"));
        String responseDate = (String)response.readEntity(this.generic(String.class), annotations);
        Assertions.assertTrue((boolean)sDate.equals(responseDate), (String)("#readEntity(String.class, annotations)={" + responseDate + "} differs from expected" + sDate));
        Assertions.assertTrue((ai.get() == expected ? 1 : 0) != 0, (String)(ai.get() + "differes from expected" + expected + "which suggest a problem with annotation passing"));
        JAXRSClientIT.logMsg("Got expected date", date);
    }

    @Test
    public void readEntityGenericTypeAnnotationIsNullWhenNoEntityTest() throws JAXRSCommonClient.Fault {
        Annotation[] annotations = AnnotatedClass.class.getAnnotations();
        Response response = this.invokeGet("status?status=200");
        String entity = (String)response.readEntity(this.generic(String.class), annotations);
        Assertions.assertTrue((entity == null || "".equals(entity) ? 1 : 0) != 0, (String)("entity is not null or zero length" + entity));
        JAXRSClientIT.logMsg("Null or zero length entity returned when no entity as expected");
    }

    @Test
    public void readEntityGenericTypeAnnotationCloseIsCalledTest() throws JAXRSCommonClient.Fault {
        final Annotation[] annotations = AnnotatedClass.class.getAnnotations();
        AtomicInteger ai = this.setCorruptedStream();
        final Response response = this.invokeGet("corrupted");
        this.catchCorruptedStreamException(new Runnable(){

            @Override
            public void run() {
                response.readEntity(JAXRSClientIT.this.generic(String.class), annotations);
            }
        });
        JAXRSClientIT.assertEqualsInt(ai.get(), 999, "Close has not been called");
        JAXRSClientIT.logMsg("Close() has been called on an entity stream as expected");
    }

    @Test
    public void readEntityGenericTypeAnnotationCloseIsNotCalledOnInputStreamTest() throws JAXRSCommonClient.Fault {
        Annotation[] annotations = AnnotatedClass.class.getAnnotations();
        AtomicInteger ai = this.setCorruptedStream();
        Response response = this.invokeGet("corrupted");
        try {
            response.readEntity(this.generic(InputStream.class), annotations);
        }
        catch (ProcessingException e) {
            JAXRSClientIT.fault(new Object[]{"Close was called", e});
        }
        JAXRSClientIT.assertEqualsInt(ai.get(), 0, "Close was called");
        JAXRSClientIT.logMsg("Close() has not been called on entity stream as expected");
    }

    @Test
    public void readEntityGenericTypeAnnotationThrowsProcessingExceptionTest() throws JAXRSCommonClient.Fault {
        Annotation[] annotations = AnnotatedClass.class.getAnnotations();
        Response response = this.invokeGet("entity");
        try {
            response.readEntity(this.generic(Void.class), annotations);
            throw new JAXRSCommonClient.Fault("No exception has been thrown when reader for entity class is not known");
        }
        catch (ProcessingException e) {
            JAXRSClientIT.logMsg("ProcessingException has been thrown as expected");
            return;
        }
    }

    @Test
    public void readEntityGenericTypeAnnotationThrowsIllegalStateExceptionTest() throws JAXRSCommonClient.Fault {
        Annotation[] annotations = AnnotatedClass.class.getAnnotations();
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target("http://" + this._hostname + ":" + this._port + this.getContextRoot()).path("entity");
        Response response = target.request(new MediaType[]{MediaType.TEXT_PLAIN_TYPE}).buildGet().invoke();
        String entity = (String)response.readEntity(this.generic(String.class), annotations);
        Assertions.assertTrue((boolean)"ENtiTy".equals(entity), (String)("#readEntity(GenericType<String>, annotations)={" + entity + "} differs from expectedENtiTy"));
        try {
            response.readEntity(this.generic(Reader.class), annotations);
            throw new JAXRSCommonClient.Fault("No exception has been thrown when reader for entity is not buffered");
        }
        catch (IllegalStateException e) {
            JAXRSClientIT.logMsg("IllegalStateException has been thrown as expected");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void responseCreatedRelativeURITest() throws JAXRSCommonClient.Fault {
        String resourceUrl = this.getAbsoluteUrl();
        String expected = resourceUrl.substring(0, resourceUrl.length() - "resource".length()) + "created";
        try (Response response = this.invokeGet("created");){
            Assertions.assertTrue((boolean)expected.equals(response.getHeaderString("location")), (String)("#response.getHeaderString(\"location\") [" + response.getHeaderString("location") + "] differs from " + expected));
        }
    }

    protected <T> GenericType<T> generic(Class<T> clazz) {
        return new GenericType(clazz);
    }

    protected Response invokeGet(String method) throws JAXRSCommonClient.Fault {
        String request = this.buildRequest(JAXRSCommonClient.Request.GET, method);
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_PLAIN_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, request);
        this.invoke();
        return this.getResponse();
    }

    protected Response invokePost(String method, Object entity) throws JAXRSCommonClient.Fault {
        String request = this.buildRequest(JAXRSCommonClient.Request.POST, method);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, request);
        this.setRequestContentEntity(entity);
        this.invoke();
        return this.getResponse();
    }

    protected String readLine(Reader reader) throws JAXRSCommonClient.Fault {
        String line = null;
        BufferedReader buffered = new BufferedReader(reader);
        try {
            line = buffered.readLine();
        }
        catch (IOException e) {
            try {
                buffered.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new JAXRSCommonClient.Fault(e);
        }
        return line;
    }

    protected AtomicInteger setCorruptedStream() {
        final AtomicInteger ai = new AtomicInteger(0);
        ClientResponseFilter filter = new ClientResponseFilter(){

            public void filter(ClientRequestContext arg0, ClientResponseContext response) throws IOException {
                CorruptedInputStream cis = new CorruptedInputStream("ENtiTy".getBytes(), ai);
                cis.setCorrupted(true);
                response.setEntityStream((InputStream)cis);
            }
        };
        this.addProvider(filter);
        super.setPrintEntity(false);
        return ai;
    }

    protected long getCurrentTimeMillis() {
        long millis = System.currentTimeMillis() / 1000L;
        return millis *= 1000L;
    }

    protected String langToString(Object object) {
        Locale locale = null;
        if (object instanceof List) {
            object = ((List)object).iterator().next();
        }
        if (object instanceof Locale) {
            locale = (Locale)object;
        }
        String value = locale == null ? object.toString() : locale.toString();
        return value.replace("_", "-");
    }

    protected void catchCorruptedStreamException(Runnable runnable) throws JAXRSCommonClient.Fault {
        try {
            runnable.run();
        }
        catch (ProcessingException e) {
            JAXRSClientIT.assertNotNull(e.getCause(), new Object[]{"unknown exception thrown", e});
            JAXRSClientIT.assertEquals(e.getCause().getMessage(), "CorruptedInputStream tck test IOException", new Object[]{"unknown exception thrown", e});
        }
    }

    protected void catchCorruptedStreamExceptionOnBufferEntity(final Response response) throws JAXRSCommonClient.Fault {
        this.catchCorruptedStreamException(new Runnable(){

            @Override
            public void run() {
                response.bufferEntity();
            }
        });
    }

    private <T> void assertHeaderNull(T actualHeader, ResponseHeaderValue<T> filterValue, String method) throws JAXRSCommonClient.Fault {
        if (filterValue.value == null) {
            JAXRSClientIT.assertNull(actualHeader, "response#" + method + "() should be null, was ", actualHeader);
            JAXRSClientIT.logMsg("response#" + method + "() was null as expected");
        } else {
            JAXRSClientIT.assertEquals(filterValue.value, actualHeader, "response#" + method + "() was set to " + filterValue.value, "by container but was ", actualHeader);
            JAXRSClientIT.logMsg("response#" + method + "() was set to " + actualHeader + " as preset by container");
        }
    }

    class ResponseHeaderValue<T> {
        private T value;

        ResponseHeaderValue() {
        }
    }

    abstract class HeaderNotPresent<T>
    implements ClientResponseFilter {
        private ResponseHeaderValue<T> headerValue;

        public HeaderNotPresent(ResponseHeaderValue<T> headerValue) {
            this.headerValue = headerValue;
        }

        public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
            this.setHeader(responseContext, this.headerValue);
        }

        protected abstract void setHeader(ClientResponseContext var1, ResponseHeaderValue<T> var2);
    }
}

