/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.provider.standardnotnull;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.common.impl.StringStreamingOutput;
import ee.jakarta.tck.ws.rs.common.provider.PrintingErrorHandler;
import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.spec.provider.standardnotnull.Resource;
import ee.jakarta.tck.ws.rs.spec.provider.standardnotnull.TSAppConfig;
import jakarta.activation.DataSource;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NoContentException;
import jakarta.ws.rs.core.Response;
import jakarta.xml.bind.JAXBElement;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import javax.xml.transform.Source;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_spec_provider_standardnotnull_web/resource");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/spec/provider/standardnotnull/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_spec_provider_standardnotnull_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, StringStreamingOutput.class, PrintingErrorHandler.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    @Tag(value="xml_binding")
    public void serverByteArrayProviderTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "EXPECTED");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "bytearray"));
        this.invoke();
    }

    @Test
    @Tag(value="xml_binding")
    public void clientByteArrayProviderTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "entity"));
        this.invoke();
        byte[] array = new byte[]{};
        array = (byte[])this.getResponseBody(array.getClass());
        Assertions.assertTrue((array == null || array.length == 0 ? 1 : 0) != 0, (String)("byte [] reader gets unexpected" + array));
    }

    @Test
    @Tag(value="xml_binding")
    public void serverStringProviderTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "EXPECTED");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "string"));
        this.invoke();
    }

    @Test
    @Tag(value="xml_binding")
    public void clientStringProviderTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "entity"));
        this.invoke();
        String entity = this.getResponseBody(String.class);
        Assertions.assertTrue((entity == null || entity.length() == 0 ? 1 : 0) != 0, (String)("String reader gets unexpected" + entity));
    }

    @Test
    @Tag(value="xml_binding")
    public void serverInputStreamProviderTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "EXPECTED");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "inputstream"));
        this.invoke();
    }

    @Test
    @Tag(value="xml_binding")
    public void clientInputStreamProviderTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "entity"));
        this.invoke();
        InputStream entity = this.getResponseBody(InputStream.class);
        String content = null;
        if (entity != null) {
            try {
                content = JaxrsUtil.readFromStream(entity);
            }
            catch (Exception e) {
                throw new JAXRSCommonClient.Fault(e);
            }
        }
        Assertions.assertTrue((content == null || content.length() == 0 ? 1 : 0) != 0, (String)("InputStream reader gets unexpected" + content));
    }

    @Test
    @Tag(value="xml_binding")
    public void serverReaderProviderTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "EXPECTED");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "reader"));
        this.invoke();
    }

    @Test
    @Tag(value="xml_binding")
    public void clientReaderProviderTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "entity"));
        this.invoke();
        Reader entity = this.getResponseBody(Reader.class);
        String content = null;
        if (entity != null) {
            try {
                content = JaxrsUtil.readFromReader(entity);
            }
            catch (Exception e) {
                throw new JAXRSCommonClient.Fault(e);
            }
        }
        Assertions.assertTrue((content == null || content.length() == 0 ? 1 : 0) != 0, (String)("Reader reader gets unexpected" + content));
    }

    @Test
    @Tag(value="xml_binding")
    public void serverFileProviderTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "EXPECTED");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "file"));
        this.invoke();
    }

    @Test
    @Tag(value="xml_binding")
    public void clientFileProviderTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "entity"));
        this.invoke();
        File entity = this.getResponseBody(File.class);
        String content = null;
        if (entity != null) {
            try {
                content = JaxrsUtil.readFromFile(entity);
            }
            catch (Exception e) {
                throw new JAXRSCommonClient.Fault(e);
            }
        }
        Assertions.assertTrue((content == null || content.length() == 0 ? 1 : 0) != 0, (String)("File reader gets unexpected" + content));
    }

    @Test
    @Tag(value="xml_binding")
    public void serverDataSourceProviderTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "EXPECTED");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "datasource"));
        this.invoke();
    }

    @Test
    @Tag(value="xml_binding")
    public void clientDataSourceProviderTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "entity"));
        this.invoke();
        DataSource entity = this.getResponseBody(DataSource.class);
        String content = null;
        if (entity != null) {
            try {
                content = JaxrsUtil.readFromStream(entity.getInputStream());
            }
            catch (Exception e) {
                throw new JAXRSCommonClient.Fault(e);
            }
        }
        Assertions.assertTrue((content == null || content.length() == 0 ? 1 : 0) != 0, (String)("DataSource reader gets unexpected" + content));
    }

    @Test
    @Tag(value="xml_binding")
    public void serverSourceProviderTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.APPLICATION_XML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "source"));
        this.invoke();
    }

    @Test
    @Tag(value="xml_binding")
    public void clientSourceProviderTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "entity"));
        this.invoke();
        Response response = this.getResponse();
        response.getHeaders().add((Object)"Content-Type", (Object)"application/xml");
        Source entity = this.getResponseBody(Source.class);
        String content = null;
        if (entity != null) {
            content = entity.getSystemId();
        }
        Assertions.assertTrue((content == null || content.length() == 0 ? 1 : 0) != 0, (String)("Source reader gets unexpected" + content));
    }

    @Test
    @Tag(value="xml_binding")
    public void serverMultivaluedMapProviderTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "map"));
        this.invoke();
    }

    @Test
    @Tag(value="xml_binding")
    public void clientMultivaluedMapProviderTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "entity"));
        this.invoke();
        Response response = this.getResponse();
        response.getHeaders().add((Object)"Content-Type", (Object)"application/x-www-form-urlencoded");
        MultivaluedMap entity = this.getResponseBody(MultivaluedMap.class);
        Assertions.assertTrue((entity == null || entity.size() == 0 ? 1 : 0) != 0, (String)("MultivaluedMap reader gets unexpected" + entity));
    }

    @Test
    @Tag(value="xml_binding")
    public void serverJaxbProviderTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.APPLICATION_XML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "jaxb"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.BAD_REQUEST));
        this.invoke();
    }

    @Test
    @Tag(value="xml_binding")
    public void clientJaxbProviderTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "null"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.APPLICATION_XML_TYPE));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.NO_CONTENT));
        this.invoke();
        GenericType<JAXBElement<String>> type = new GenericType<JAXBElement<String>>(){};
        JAXBElement entity = (JAXBElement)this.getResponse().readEntity((GenericType)type);
        JAXRSClientIT.assertNull(entity, "JAXBElement of content type is unexpectedly not null", entity);
        JAXRSClientIT.logMsg("Read JAXBElement entity is null as expected");
    }

    @Test
    @Tag(value="xml_binding")
    public void serverStreamingOutputProviderTest() throws JAXRSCommonClient.Fault {
        String content = "StreamingOutput";
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "streamingoutput"));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, content);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, content);
        this.invoke();
    }

    @Test
    @Tag(value="xml_binding")
    public void serverBooleanProviderTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_PLAIN_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "boolean"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.BAD_REQUEST));
        this.invoke();
    }

    @Test
    @Tag(value="xml_binding")
    public void clientBooleanProviderTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "entity"));
        this.invoke();
        Response response = this.getResponse();
        response.getHeaders().add((Object)"Content-Type", (Object)MediaType.TEXT_PLAIN_TYPE);
        try {
            Boolean entity = this.getResponseBody(Boolean.class);
            JAXRSClientIT.fault("No expcetion thrown and entity is", entity);
        }
        catch (Exception e) {
            ProcessingException p = JAXRSClientIT.assertCause(e, ProcessingException.class, "Processing exception has not been thrown", e);
            NoContentException nce = JAXRSClientIT.assertCause(e, NoContentException.class, new Object[]{"NoContentException has not been thrown", p});
            JAXRSClientIT.logMsg("Found expected NoContentException", nce);
        }
    }

    @Test
    @Tag(value="xml_binding")
    public void serverCharProviderTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_PLAIN_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "character"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.BAD_REQUEST));
        this.invoke();
    }

    @Test
    @Tag(value="xml_binding")
    public void clientCharProviderTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "entity"));
        this.invoke();
        Response response = this.getResponse();
        response.getHeaders().add((Object)"Content-Type", (Object)MediaType.TEXT_PLAIN_TYPE);
        try {
            Character entity = this.getResponseBody(Character.class);
            JAXRSClientIT.fault("No expcetion thrown and entity is", entity);
        }
        catch (Exception e) {
            ProcessingException p = JAXRSClientIT.assertCause(e, ProcessingException.class, "Processing exception has not been thrown", e);
            NoContentException nce = JAXRSClientIT.assertCause(e, NoContentException.class, new Object[]{"NoContentException has not been thrown", p});
            JAXRSClientIT.logMsg("Found expected NoContentException", nce);
        }
    }

    @Test
    @Tag(value="xml_binding")
    public void serverIntegerProviderTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_PLAIN_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "integer"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.BAD_REQUEST));
        this.invoke();
    }

    @Test
    @Tag(value="xml_binding")
    public void clientIntegerProviderTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "entity"));
        this.invoke();
        Response response = this.getResponse();
        response.getHeaders().add((Object)"Content-Type", (Object)MediaType.TEXT_PLAIN_TYPE);
        try {
            Integer entity = this.getResponseBody(Integer.class);
            JAXRSClientIT.fault("No expcetion thrown and entity is", entity);
        }
        catch (Exception e) {
            ProcessingException p = JAXRSClientIT.assertCause(e, ProcessingException.class, "Processing exception has not been thrown", e);
            NoContentException nce = JAXRSClientIT.assertCause(e, NoContentException.class, new Object[]{"NoContentException has not been thrown", p});
            JAXRSClientIT.logMsg("Found expected NoContentException", nce);
        }
    }

    @Test
    @Tag(value="xml_binding")
    public void serverBigDecimalProviderTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_PLAIN_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "bigdecimal"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.BAD_REQUEST));
        this.invoke();
    }

    @Test
    @Tag(value="xml_binding")
    public void clientBigDecimalProviderTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "entity"));
        this.invoke();
        Response response = this.getResponse();
        response.getHeaders().add((Object)"Content-Type", (Object)MediaType.TEXT_PLAIN_TYPE);
        try {
            BigDecimal entity = this.getResponseBody(BigDecimal.class);
            JAXRSClientIT.fault("No expcetion thrown and entity is", entity);
        }
        catch (Exception e) {
            ProcessingException p = JAXRSClientIT.assertCause(e, ProcessingException.class, "Processing exception has not been thrown", e);
            NoContentException nce = JAXRSClientIT.assertCause(e, NoContentException.class, new Object[]{"NoContentException has not been thrown", p});
            JAXRSClientIT.logMsg("Found expected NoContentException", nce);
        }
    }
}

