/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.internal.backend;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import org.eclipse.fx.drift.RenderTarget;
import org.eclipse.fx.drift.SwapchainConfig;
import org.eclipse.fx.drift.internal.DriftFX;
import org.eclipse.fx.drift.internal.DriftLogger;
import org.eclipse.fx.drift.internal.backend.Backend;
import org.eclipse.fx.drift.internal.backend.BackendSwapchain;
import org.eclipse.fx.drift.internal.backend.Image;
import org.eclipse.fx.drift.internal.backend.ImageFactory;
import org.eclipse.fx.drift.internal.common.ImageData;
import org.eclipse.fx.drift.internal.transport.command.DisposeSwapchainCommand;
import org.eclipse.fx.drift.internal.transport.command.PresentCommand;

public class SimpleSwapchain
implements BackendSwapchain {
    private static final DriftLogger LOGGER = DriftFX.createLogger(SimpleSwapchain.class);
    private final UUID id;
    private final Backend backend;
    private final SwapchainConfig config;
    private Set<Image> images;
    private Map<ImageData, Image> imageMap;
    private BlockingQueue<Image> freeImages = new LinkedBlockingQueue<Image>();
    private boolean disposed = false;

    public SimpleSwapchain(Backend backend, UUID id, SwapchainConfig config) {
        this.backend = backend;
        this.id = id;
        this.config = config;
    }

    @Override
    public SwapchainConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void allocate() {
        LOGGER.debug(() -> "Allocating Swapchain");
        BlockingQueue<Image> blockingQueue = this.freeImages;
        synchronized (blockingQueue) {
            this.images = new HashSet<Image>();
            this.imageMap = new HashMap<ImageData, Image>();
            for (int number = 0; number < this.config.imageCount; ++number) {
                Image image = ImageFactory.createImage(number, this.config.size, this.config.transferType);
                image.allocate();
                this.images.add(image);
                this.freeImages.add(image);
                this.imageMap.put(image.getData(), image);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        LOGGER.debug(() -> "Disposing Swapchain");
        long disposeBegin = System.nanoTime();
        this.backend.sendCommand(new DisposeSwapchainCommand(this.id));
        while (this.freeImages.size() != this.images.size()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        LOGGER.debug(() -> "Dispose waiting time was " + (System.nanoTime() - disposeBegin) + "ns");
        BlockingQueue<Image> blockingQueue = this.freeImages;
        synchronized (blockingQueue) {
            for (Image image : this.freeImages) {
                image.release();
            }
            this.images.removeAll(this.freeImages);
            if (!this.images.isEmpty()) {
                LOGGER.error(() -> "Unreleased Swapchain images remaining: " + this.images);
            }
            this.disposed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RenderTarget acquire() throws InterruptedException {
        BlockingQueue<Image> blockingQueue = this.freeImages;
        synchronized (blockingQueue) {
            Image image = this.freeImages.take();
            image.onAcquire();
            return image;
        }
    }

    @Override
    public void release(ImageData imageData) {
        Image image = this.imageMap.get(imageData);
        if (image == null) {
            LOGGER.error(() -> "Wrong image released !!!!!");
        } else {
            this.freeImages.add(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<RenderTarget> tryAcquire() {
        BlockingQueue<Image> blockingQueue = this.freeImages;
        synchronized (blockingQueue) {
            if (this.freeImages.isEmpty()) {
                return Optional.empty();
            }
            Image image = (Image)this.freeImages.poll();
            if (image != null) {
                image.onAcquire();
            }
            return Optional.of(image);
        }
    }

    @Override
    public void present(RenderTarget renderTarget) {
        Image image = (Image)renderTarget;
        image.onPresent();
        this.backend.sendCommand(new PresentCommand(this.id, image.getData()));
    }

    @Override
    public List<ImageData> getImages() {
        return this.images.stream().map(Image::getData).collect(Collectors.toList());
    }
}

