/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.internal;

import java.util.function.Supplier;
import org.eclipse.fx.drift.DriftFXConfig;
import org.eclipse.fx.drift.LoggingService;
import org.eclipse.fx.drift.internal.DriftLogger;

public class DefaultLogger
implements DriftLogger {
    private Class<?> ctx;
    private LoggingService loggingService;

    public DefaultLogger(Class<?> ctx) {
        this.ctx = ctx;
        this.loggingService = DriftFXConfig.getLoggingService();
    }

    @Override
    public void trace(Supplier<String> msg) {
        this.loggingService.log(6, this.ctx, msg, null);
    }

    @Override
    public void debug(Supplier<String> msg) {
        this.loggingService.log(5, this.ctx, msg, null);
    }

    @Override
    public void info(Supplier<String> msg) {
        this.loggingService.log(4, this.ctx, msg, null);
    }

    @Override
    public void warn(Supplier<String> msg) {
        this.loggingService.log(3, this.ctx, msg, null);
    }

    @Override
    public void error(Supplier<String> msg) {
        this.loggingService.log(2, this.ctx, msg, null);
    }

    @Override
    public void error(Supplier<String> msg, Throwable t) {
        this.loggingService.log(2, this.ctx, msg, null);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.loggingService.isActive(6);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.loggingService.isActive(5);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.loggingService.isActive(4);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.loggingService.isActive(3);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.loggingService.isActive(2);
    }
}

